/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.query.rx;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.Iterator;
import java.util.List;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecOverRowSet;
import org.aksw.jenax.sparql.rx.op.FlowOfBindingsOps;
import org.aksw.jenax.stmt.core.SparqlStmtQuery;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecutionAdapter;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.RowSetStream;

public interface ResultSetRx {
    public SparqlStmtQuery getQueryStmt();

    public List<Var> getVars();

    public Flowable<Binding> getBindings();

    default public QueryIterator asQueryIterator() {
        Flowable<Binding> bindingFlow = this.getBindings();
        return FlowOfBindingsOps.toQueryIterator(bindingFlow);
    }

    default public QueryExecution asQueryExecution() {
        QueryExec qExec = this.asQueryExec();
        return QueryExecutionAdapter.adapt((QueryExec)qExec);
    }

    default public QueryExec asQueryExec() {
        SparqlStmtQuery queryStmt = this.getQueryStmt();
        Query query = queryStmt == null ? null : queryStmt.getQuery();
        QueryExecOverRowSet result = new QueryExecOverRowSet(query){
            protected Disposable disposable;
            {
                this.disposable = null;
            }

            public void abort() {
                this.close();
            }

            public void closeActual() {
                if (this.disposable != null) {
                    this.disposable.dispose();
                }
            }

            protected RowSet createRowSet(Query query) {
                if (this.disposable != null) {
                    throw new IllegalStateException("execSelect has already been called");
                }
                List<Var> vars = ResultSetRx.this.getVars();
                Flowable<Binding> flowable = ResultSetRx.this.getBindings();
                Iterator it = flowable.blockingIterable().iterator();
                this.disposable = (Disposable)it;
                RowSet r = RowSetStream.create(vars, it);
                return r;
            }
        };
        return result;
    }
}

