/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx.io.resultset;

import com.google.common.collect.Iterables;
import java.util.Collection;
import org.aksw.jena_sparql_api.rx.io.resultset.OutputMode;
import org.aksw.jena_sparql_api.rx.io.resultset.OutputModes;
import org.aksw.jenax.arq.util.lang.RDFLanguagesEx;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.resultset.ResultSetLang;

public class OutputFormatSpec {
    protected OutputMode outputMode;
    protected Lang outRdfLang = null;
    protected RDFFormat outRdfFormat = null;

    public OutputFormatSpec(OutputMode outputMode, RDFFormat outRdfFormat, Lang outLang) {
        this.outputMode = outputMode;
        this.outRdfFormat = outRdfFormat;
        this.outRdfLang = outLang;
    }

    public OutputMode getOutputMode() {
        return this.outputMode;
    }

    public RDFFormat getOutRdfFormat() {
        return this.outRdfFormat;
    }

    public Lang getOutLang() {
        return this.outRdfLang;
    }

    public static OutputFormatSpec create(String outFormat, RDFFormat tripleFormat, RDFFormat quadFormat, Collection<? extends SparqlStmt> stmts, boolean jqMode) {
        OutputMode outputMode;
        RDFFormat outRdfFormat = null;
        Lang outLang = null;
        if (outFormat != null) {
            if ("json".equalsIgnoreCase(outFormat)) {
                outputMode = OutputMode.JSON;
            } else {
                if ("list".equalsIgnoreCase(outFormat) || "help".equalsIgnoreCase(outFormat)) {
                    throw new IllegalStateException("Available out formats:\n" + String.join((CharSequence)"\n", RDFLanguagesEx.listOutFormats()));
                }
                try {
                    outRdfFormat = RDFLanguagesEx.findRdfFormat((String)outFormat);
                    outLang = outRdfFormat.getLang();
                }
                catch (Exception e) {
                    outLang = RDFLanguagesEx.findLang((String)outFormat);
                }
                outputMode = OutputModes.determineOutputMode(outLang);
            }
        } else {
            outputMode = jqMode ? OutputMode.JSON : OutputModes.detectOutputMode(stmts);
            switch (outputMode) {
                case BINDING: {
                    outLang = ResultSetLang.RS_JSON;
                    break;
                }
                case TRIPLE: {
                    outRdfFormat = tripleFormat;
                    outLang = outRdfFormat.getLang();
                    break;
                }
                case QUAD: {
                    outRdfFormat = quadFormat;
                    outLang = outRdfFormat.getLang();
                    break;
                }
                case JSON: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown output mode");
                }
            }
        }
        return new OutputFormatSpec(outputMode, outRdfFormat, outLang);
    }

    public String getFileExtension() {
        String result;
        if (this.outputMode.equals((Object)OutputMode.JSON)) {
            result = "json";
        } else {
            Lang lang = this.outRdfFormat != null ? this.outRdfFormat.getLang() : this.outRdfLang;
            result = lang == null ? null : (String)Iterables.getFirst((Iterable)lang.getFileExtensions(), null);
        }
        return result;
    }
}

