/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.mem.QuadTable;
import org.apache.jena.sparql.core.mem.TripleTable;

public class TripleTableFromQuadTable
implements TripleTable {
    protected Node targetGraph;
    protected QuadTable quadTable;

    public TripleTableFromQuadTable(QuadTable quadTable) {
        this(quadTable, Quad.defaultGraphIRI);
    }

    public TripleTableFromQuadTable(QuadTable quadTable, Node targetGraph) {
        this.quadTable = quadTable;
        this.targetGraph = targetGraph;
    }

    public void clear() {
        List removals = this.quadTable.find(this.targetGraph, null, null, null).collect(Collectors.toList());
        for (Quad q : removals) {
            this.quadTable.delete((Object)q);
        }
    }

    public void add(Triple t) {
        this.quadTable.add((Object)Quad.create((Node)this.targetGraph, (Triple)t));
    }

    public void delete(Triple t) {
        this.quadTable.delete((Object)Quad.create((Node)this.targetGraph, (Triple)t));
    }

    public void begin(ReadWrite readWrite) {
        this.quadTable.begin(readWrite);
    }

    public void commit() {
        this.quadTable.commit();
    }

    public void end() {
        this.quadTable.end();
    }

    public Stream<Triple> find(Node s, Node p, Node o) {
        return this.quadTable.find(this.targetGraph, s, p, o).map(Quad::asTriple);
    }
}

