/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.commons.collector.domain.Aggregator;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.modify.TemplateLib;
import org.apache.jena.sparql.syntax.Template;

public class AggObjectGraph
implements Aggregator<Binding, FunctionEnv, Graph> {
    protected Template template;
    protected Map<Node, ? extends Function<? super Binding, ? extends Node>> nodeIdGenMap;
    protected Supplier<Graph> graphSupplier;
    protected Set<? extends Node> trackedTemplateNodes;

    public AggObjectGraph(Template template, Set<? extends Node> trackedTemplateNodes, Supplier<Graph> graphSupplier, Map<Node, ? extends Function<? super Binding, ? extends Node>> nodeIdGenMap) {
        this.template = template;
        this.trackedTemplateNodes = trackedTemplateNodes;
        this.graphSupplier = graphSupplier;
        this.nodeIdGenMap = nodeIdGenMap;
    }

    public AccObjectGraph createAccumulator() {
        Graph graph = this.graphSupplier.get();
        return new AccObjectGraph(graph);
    }

    public class AccObjectGraph
    implements Accumulator<Binding, FunctionEnv, Graph> {
        protected Graph graph;
        protected SetMultimap<Node, Node> templateNodeToInsts;

        public AccObjectGraph(Graph graph) {
            this.graph = graph;
            this.templateNodeToInsts = HashMultimap.create();
        }

        public void accumulate(Binding binding, FunctionEnv env) {
            HashMap<Node, Node> bnodeMap = new HashMap<Node, Node>();
            for (Map.Entry<Node, ? extends Function<? super Binding, ? extends Node>> entry : AggObjectGraph.this.nodeIdGenMap.entrySet()) {
                Node templateNode = entry.getKey();
                Function<? super Binding, ? extends Node> idGen = entry.getValue();
                Node id = idGen.apply((Binding)binding);
                bnodeMap.put(templateNode, id);
            }
            for (Triple triple : AggObjectGraph.this.template.getTriples()) {
                Triple newT = TemplateLib.subst((Triple)triple, (Binding)binding, bnodeMap);
                if (!newT.isConcrete()) continue;
                this.graph.add(newT);
            }
            for (Node node : AggObjectGraph.this.trackedTemplateNodes) {
                Node remapped;
                if (node.isVariable()) {
                    Var var = (Var)node;
                    remapped = binding.get(var);
                } else {
                    remapped = (Node)bnodeMap.get(node);
                }
                if (remapped == null) continue;
                this.templateNodeToInsts.put((Object)node, (Object)remapped);
            }
        }

        public Set<Node> getTrackedNodes(Node templateNode) {
            Set result = this.templateNodeToInsts.get((Object)templateNode);
            return result;
        }

        public Graph getValue() {
            return this.graph;
        }
    }
}

