/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.rx.op;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.functions.BiFunction;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.aksw.commons.collector.domain.ParallelAggregator;
import org.aksw.commons.lambda.serializable.SerializableSupplier;
import org.aksw.commons.rx.op.RxOps;
import org.aksw.jena_sparql_api.rx.io.resultset.OutputMode;
import org.aksw.jena_sparql_api.rx.io.resultset.SPARQLResultExVisitor;
import org.aksw.jena_sparql_api.rx.io.resultset.SPARQLResultExVisitorCollector;
import org.aksw.jenax.arq.json.RdfJsonUtils;
import org.aksw.jenax.arq.util.binding.ResultSetUtils;
import org.aksw.jenax.dataaccess.sparql.connection.common.RDFConnectionUtils;
import org.aksw.jenax.sparql.query.rx.ResultSetRx;
import org.aksw.jenax.sparql.query.rx.ResultSetRxImpl;
import org.aksw.jenax.sparql.query.rx.SparqlRx;
import org.aksw.jenax.sparql.rx.op.AggBuilderDataset;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.resultset.SPARQLResultEx;
import org.aksw.jenax.stmt.util.SparqlStmtUtils;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionFactory;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.util.Context;

public class SparqlMappers {
    public static Function<RDFConnection, ResultSetRx> createProcessorResultSetRx(List<SparqlStmt> stmts, SPARQLResultExVisitor<?> sparqlResultExVisitor) {
        List vars = SparqlStmtUtils.getUnionProjectVars(stmts);
        Function<RDFConnection, Flowable<Binding>> mapper = SparqlMappers.createMapperBinding(stmts, sparqlResultExVisitor);
        return conn -> ResultSetRxImpl.create(vars, (Flowable<Binding>)((Flowable)mapper.apply((RDFConnection)conn)));
    }

    public static <I, O> FlowableTransformer<I, O> createParallelMapperOrdered(boolean parallel, Function<? super I, O> mapper) {
        return parallel ? RxOps.createParallelMapperOrdered(mapper) : upstream -> upstream.map(mapper::apply);
    }

    public static <I extends Dataset, O> Function<I, O> mapDatasetToConnection(Function<? super RDFConnection, O> mapper) {
        return dataset -> {
            Object r;
            try (RDFConnection conn = RDFConnectionFactory.connect((Dataset)dataset);){
                r = mapper.apply(conn);
            }
            return r;
        };
    }

    public static Function<RDFConnection, RDFConnection> applyContextHandler(Consumer<Context> contextHandler) {
        return conn -> contextHandler == null ? conn : RDFConnectionUtils.wrapWithContextMutator((RDFConnection)conn, (Consumer)contextHandler);
    }

    public static <T> Flowable<T> fallbackToVisitor(RDFConnection conn, SparqlStmt stmt, SPARQLResultExVisitor<?> sparqlResultVisitor) throws Exception {
        try (SPARQLResultEx sr = SparqlStmtUtils.execAny((RDFConnection)conn, (SparqlStmt)stmt, null);){
            if (sparqlResultVisitor != null) {
                sparqlResultVisitor.forwardEx(sr);
            }
        }
        return Flowable.empty();
    }

    public static Function<RDFConnection, Flowable<Binding>> createMapperBinding(Collection<? extends SparqlStmt> stmts, SPARQLResultExVisitor<?> sparqlResultVisitor) {
        return SparqlMappers.createMapperSelect(stmts, sparqlResultVisitor, (conn, query) -> SparqlRx.execSelectRaw(conn, query));
    }

    public static Function<RDFConnection, Flowable<QuerySolution>> createMapperQuerySolution(Collection<? extends SparqlStmt> stmts, SPARQLResultExVisitor<?> sparqlResultVisitor) {
        return SparqlMappers.createMapperSelect(stmts, sparqlResultVisitor, (conn, query) -> SparqlRx.execSelect(conn, query));
    }

    public static <B> Function<RDFConnection, Flowable<B>> createMapperSelect(Collection<? extends SparqlStmt> stmts, SPARQLResultExVisitor<?> sparqlResultVisitor, BiFunction<? super SparqlQueryConnection, ? super Query, Flowable<B>> execSelect) {
        return conn -> Flowable.fromIterable((Iterable)stmts).flatMap(stmt -> {
            Query query;
            Flowable r = null;
            if (stmt.isQuery() && (query = stmt.getQuery()).isSelectType()) {
                r = (Flowable)execSelect.apply(conn, (Object)query);
            }
            r = r != null ? r : SparqlMappers.fallbackToVisitor(conn, stmt, sparqlResultVisitor);
            return r;
        });
    }

    public static Function<RDFConnection, Flowable<Quad>> createMapperQuad(Collection<? extends SparqlStmt> stmts, SPARQLResultExVisitor<?> sparqlResultVisitor) {
        return conn -> Flowable.fromIterable((Iterable)stmts).flatMap(stmt -> {
            Query query;
            Object r = null;
            if (stmt.isQuery() && (query = stmt.getQuery()).isConstructType()) {
                r = query.isConstructQuad() ? SparqlRx.execConstructQuads((SparqlQueryConnection)conn, query) : SparqlRx.execConstructTriples((SparqlQueryConnection)conn, query).map(t -> new Quad(Quad.defaultGraphNodeGenerated, t));
            }
            r = r != null ? r : SparqlMappers.fallbackToVisitor(conn, stmt, sparqlResultVisitor);
            return r;
        });
    }

    public static Function<RDFConnection, Iterable<Dataset>> createMapperDataset(Collection<? extends SparqlStmt> stmts, SPARQLResultExVisitor<?> sparqlResultVisitor, Supplier<? extends DatasetGraph> datasetGraphSupplier) {
        ParallelAggregator agg = AggBuilderDataset.groupQuadsToDatasetCore((SerializableSupplier<? extends DatasetGraph>)((SerializableSupplier & Serializable)datasetGraphSupplier::get), Quad::getGraph);
        return SparqlMappers.createMapperQuad(stmts, sparqlResultVisitor).andThen(quadFlow -> {
            Map groupedDatasets = (Map)quadFlow.reduceWith(() -> ((ParallelAggregator)agg).createAccumulator(), (acc, item) -> {
                acc.accumulate(item);
                return acc;
            }).map(acc -> (Map)acc.getValue()).blockingGet();
            return groupedDatasets.values();
        });
    }

    public static Function<RDFConnection, Flowable<org.apache.jena.atlas.json.JsonObject>> createMapperJson(Collection<? extends SparqlStmt> stmts, SPARQLResultExVisitor<?> sparqlResultVisitor) {
        return conn -> Flowable.fromIterable((Iterable)stmts).flatMap(stmt -> {
            Query query;
            Object r = null;
            if (stmt.isQuery() && (query = stmt.getQuery()).isJsonType()) {
                r = SparqlRx.execJsonItems((SparqlQueryConnection)conn, query);
            }
            r = r != null ? r : SparqlMappers.fallbackToVisitor(conn, stmt, sparqlResultVisitor);
            return r;
        });
    }

    public static Function<RDFConnection, SPARQLResultEx> createMapperToSparqlResultEx(OutputMode outputMode, Collection<? extends SparqlStmt> stmts, SPARQLResultExVisitor<?> sparqlResultVisitor) {
        List unionProjectVars = SparqlStmtUtils.getUnionProjectVars(stmts);
        Supplier<SPARQLResultExVisitorCollector> collectorSupp = () -> new SPARQLResultExVisitorCollector(unionProjectVars);
        return switch (outputMode) {
            case OutputMode.TRIPLE, OutputMode.QUAD -> SparqlMappers.createMapperQuad(stmts, sparqlResultVisitor).andThen(quads -> (SPARQLResultEx)quads.reduceWith(((Supplier)collectorSupp)::get, (supp, quad) -> {
                supp.onQuads((Iterator)Collections.singleton(quad).iterator());
                return supp;
            }).map(collector -> collector.getResult(outputMode)).blockingGet());
            case OutputMode.BINDING -> SparqlMappers.createMapperBinding(stmts, sparqlResultVisitor).andThen(bindings -> (SPARQLResultEx)bindings.reduceWith(((Supplier)collectorSupp)::get, (supp, binding) -> {
                supp.onResultSet(ResultSetUtils.createUsingVars((Iterable)unionProjectVars, Collections.singleton(binding).iterator()));
                return supp;
            }).map(collector -> collector.getResult(outputMode)).blockingGet());
            case OutputMode.JSON -> SparqlMappers.createMapperJson(stmts, sparqlResultVisitor).andThen(jsons -> (SPARQLResultEx)jsons.reduceWith(((Supplier)collectorSupp)::get, (supp, json) -> {
                supp.onJsonItems((Iterator)Collections.singleton(json).iterator());
                return supp;
            }).map(collector -> collector.getResult(outputMode)).blockingGet());
            default -> throw new IllegalArgumentException("Unknown output mode: " + String.valueOf((Object)outputMode));
        };
    }

    public static Function<RDFConnection, Flowable<JsonElement>> createMapperJq(Collection<? extends SparqlStmt> stmts, SPARQLResultExVisitor<?> sparqlResultVisitor, int depth, boolean flat) {
        return SparqlMappers.createMapperQuerySolution(stmts, sparqlResultVisitor).andThen(flowable -> flowable.map(qs -> {
            JsonObject json = RdfJsonUtils.toJson((QuerySolution)qs, (int)depth, (boolean)flat);
            return json;
        }));
    }
}

