/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.rx.op;

import com.google.common.base.Preconditions;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.io.Serializable;
import java.util.Iterator;
import org.aksw.commons.rx.function.RxFunction;
import org.aksw.jenax.sparql.rx.op.QueryFlowOps;
import org.aksw.jenax.stmt.parser.query.SparqlQueryParserImpl;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.syntax.Template;

public class FlowOfBindingsOps {
    public static QueryIterator toQueryIterator(Flowable<Binding> bindingFlow) {
        final Iterator tmp = bindingFlow.blockingIterable().iterator();
        QueryIterPlainWrapper result = new QueryIterPlainWrapper(tmp){

            protected void requestCancel() {
                ((Disposable)tmp).dispose();
                super.requestCancel();
            }

            protected void closeIterator() {
                ((Disposable)tmp).dispose();
                super.closeIterator();
            }
        };
        return result;
    }

    public static RxFunction<Binding, Dataset> tarqlDatasets(Query query) {
        Preconditions.checkArgument((boolean)query.isConstructType(), (Object)"Construct query expected");
        String queryStr = query.toString();
        return (RxFunction & Serializable)upstream -> {
            Query q = SparqlQueryParserImpl.createAsGiven().apply(queryStr);
            Template template = q.getConstructTemplate();
            Op op = Algebra.compile((Query)q);
            return upstream.compose(QueryFlowOps.createMapperBindings(op)).flatMap(QueryFlowOps.createMapperQuads(template)::apply).reduceWith(DatasetGraphFactory::create, (dsg, quad) -> {
                dsg.add(quad);
                return dsg;
            }).map(DatasetFactory::wrap).toFlowable();
        };
    }
}

