/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.query.rx;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.aksw.jenax.arq.dataset.orderaware.DatasetFactoryEx;
import org.aksw.jenax.arq.util.quad.DatasetGraphUtils;
import org.aksw.jenax.arq.util.quad.QuadUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;

public class StreamUtils {
    public static final String DISTINGUISHED_PREFIX = "x-distinguished:";
    public static final int DISTINGUISHED_PREFIX_LENGTH = "x-distinguished:".length();

    public static Node encodeDistinguished(Node g) {
        Node result = g;
        if (g.isURI()) {
            String str = DISTINGUISHED_PREFIX + g.getURI();
            result = NodeFactory.createURI((String)str);
        }
        return result;
    }

    public static Quad encodeDistinguished(Quad quad) {
        Node g = quad.getGraph();
        Node encoded = StreamUtils.encodeDistinguished(g);
        Quad result = encoded == g ? quad : new Quad(encoded, quad.asTriple());
        return result;
    }

    public static Node decodeDistinguished(Node g) {
        String str;
        Node result = g;
        if (g.isURI() && (str = g.getURI()).startsWith(DISTINGUISHED_PREFIX)) {
            result = NodeFactory.createURI((String)str.substring(DISTINGUISHED_PREFIX_LENGTH));
        }
        return result;
    }

    public static Quad decodeDistinguished(Quad quad) {
        String str;
        Quad result = quad;
        Node g = quad.getGraph();
        if (g.isURI() && (str = g.getURI()).startsWith(DISTINGUISHED_PREFIX)) {
            result = new Quad(NodeFactory.createURI((String)str.substring(DISTINGUISHED_PREFIX_LENGTH)), quad.asTriple());
        }
        return result;
    }

    @Deprecated
    public static class QuadEncoderMergeOld {
        protected Dataset pending = DatasetFactory.create();

        public synchronized Dataset accept(Dataset dataset) {
            Graph src;
            HashSet before = Sets.newHashSet((Iterator)this.pending.asDatasetGraph().listGraphNodes());
            HashSet now = Sets.newHashSet((Iterator)dataset.asDatasetGraph().listGraphNodes());
            Sets.SetView readyGraphs = Sets.difference((Set)before, (Set)now);
            Sets.SetView appendings = Sets.union((Set)Sets.intersection((Set)before, (Set)now), (Set)Sets.difference((Set)now, (Set)before));
            for (Node appending : appendings) {
                Graph tgt = this.pending.asDatasetGraph().getGraph(appending);
                src = dataset.asDatasetGraph().getGraph(appending);
                GraphUtil.addInto((Graph)tgt, (Graph)src);
            }
            Dataset result = DatasetFactory.create();
            for (Node ready : readyGraphs) {
                src = this.pending.asDatasetGraph().getGraph(ready);
                DatasetGraphUtils.addAll((DatasetGraph)result.asDatasetGraph(), (Node)ready, (Graph)src);
                this.pending.asDatasetGraph().removeGraph(ready);
            }
            System.err.println("Pending size " + this.pending.asDatasetGraph().size());
            return result;
        }

        public Dataset getPendingDataset() {
            return this.pending;
        }
    }

    public static abstract class ConsecutiveNamedGraphMergerCore<T> {
        protected Map<Node, Set<Quad>> pending = new LinkedHashMap<Node, Set<Quad>>();

        public synchronized Optional<T> accept(Dataset dataset) {
            Supplier<Set> setSupplier = LinkedHashSet::new;
            Iterator it = dataset.asDatasetGraph().find();
            Map index = QuadUtils.partitionByGraph((Iterator)it, new LinkedHashMap(), setSupplier);
            Set<Node> before = this.pending.keySet();
            Set now = index.keySet();
            Sets.SetView overlap = Sets.intersection(now, before);
            Sets.SetView newGraphs = Sets.difference(now, before);
            for (Node appending : overlap) {
                Set<Quad> tgt = this.pending.get(appending);
                Set src = (Set)index.get(appending);
                tgt.addAll(src);
            }
            for (Node newGraph : newGraphs) {
                Set src = (Set)index.get(newGraph);
                this.pending.put(newGraph, src);
            }
            Dataset resultDataset = DatasetFactoryEx.createInsertOrderPreservingDataset();
            HashSet<Node> readyGraphs = new HashSet<Node>((Collection<Node>)Sets.difference(before, now));
            for (Node ready : readyGraphs) {
                Set<Quad> quads = this.pending.get(ready);
                DatasetGraphUtils.addAll((DatasetGraph)resultDataset.asDatasetGraph(), quads);
                this.pending.remove(ready);
            }
            Object result = readyGraphs.isEmpty() ? null : (Object)this.mapResult(readyGraphs, resultDataset);
            return Optional.ofNullable(result);
        }

        protected abstract T mapResult(Set<Node> var1, Dataset var2);

        public Optional<T> getPendingDataset() {
            Object resultData;
            if (this.pending.isEmpty()) {
                resultData = null;
            } else {
                Dataset dataset = DatasetFactoryEx.createInsertOrderPreservingDataset();
                for (Collection collection : this.pending.values()) {
                    DatasetGraphUtils.addAll((DatasetGraph)dataset.asDatasetGraph(), (Iterable)collection);
                }
                resultData = this.mapResult(this.pending.keySet(), dataset);
            }
            return Optional.ofNullable(resultData);
        }
    }

    public static class ConsecutiveNamedGraphMerger
    extends ConsecutiveNamedGraphMergerCore<Dataset> {
        @Override
        protected Dataset mapResult(Set<Node> readyGraphs, Dataset dataset) {
            return dataset;
        }
    }

    public static class QuadEncoderDistinguish {
        protected Set<Node> priorGraphs = Collections.emptySet();

        public Dataset encode(Dataset dataset) {
            HashSet now = Sets.newHashSet((Iterator)dataset.asDatasetGraph().listGraphNodes());
            ArrayList quads = Lists.newArrayList((Iterator)dataset.asDatasetGraph().find());
            Sets.SetView conflicts = Sets.intersection(this.priorGraphs, (Set)now);
            List newQuads = quads.stream().map(arg_0 -> QuadEncoderDistinguish.lambda$encode$0((Set)conflicts, arg_0)).collect(Collectors.toList());
            this.priorGraphs = now.stream().map(arg_0 -> QuadEncoderDistinguish.lambda$encode$1((Set)conflicts, arg_0)).collect(Collectors.toSet());
            Dataset result = DatasetFactoryEx.createInsertOrderPreservingDataset(newQuads);
            return result;
        }

        private static /* synthetic */ Node lambda$encode$1(Set conflicts, Node n) {
            return conflicts.contains(n) ? StreamUtils.encodeDistinguished(n) : n;
        }

        private static /* synthetic */ Quad lambda$encode$0(Set conflicts, Quad q) {
            return conflicts.contains(q.getGraph()) ? StreamUtils.encodeDistinguished(q) : q;
        }
    }
}

