/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx.script;

import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystemException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.aksw.jena_sparql_api.rx.script.MultiException;
import org.aksw.jenax.arq.util.node.NodeEnvsubst;
import org.aksw.jenax.arq.util.prefix.PrefixUtils;
import org.aksw.jenax.sparql.query.rx.RDFDataMgrEx;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.core.SparqlStmtMgr;
import org.aksw.jenax.stmt.core.SparqlStmtParser;
import org.aksw.jenax.stmt.core.SparqlStmtParserImpl;
import org.aksw.jenax.stmt.core.SparqlStmtUpdate;
import org.aksw.jenax.stmt.parser.query.SparqlQueryParser;
import org.aksw.jenax.stmt.parser.query.SparqlQueryParserImpl;
import org.aksw.jenax.stmt.parser.query.SparqlQueryParserWrapperSelectShortForm;
import org.aksw.jenax.stmt.parser.update.SparqlUpdateParser;
import org.aksw.jenax.stmt.parser.update.SparqlUpdateParserImpl;
import org.aksw.jenax.stmt.util.SparqlStmtIterator;
import org.aksw.jenax.stmt.util.SparqlStmtUtils;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.irix.IRIxResolver;
import org.apache.jena.query.Syntax;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.modify.request.UpdateLoad;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateRequest;
import org.apache.jena.util.SplitIRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlScriptProcessor {
    public static final String cwdKey = "cwd=";
    public static final String cwdResetCwd = "cwd";
    public static final String graphKey = "graph=";
    public static final String graphResetKey = "graph";
    private static final Logger logger = LoggerFactory.getLogger(SparqlScriptProcessor.class);
    protected Function<? super Prologue, ? extends SparqlStmtParser> sparqlParserFactory;
    protected PrefixMapping globalPrefixes;
    protected Path cwd = null;
    protected Node targetGraph = null;
    protected List<Map.Entry<SparqlStmt, Provenance>> sparqlStmts = new ArrayList<Map.Entry<SparqlStmt, Provenance>>();
    protected List<Function<? super SparqlStmt, ? extends SparqlStmt>> postTransformers = new ArrayList<Function<? super SparqlStmt, ? extends SparqlStmt>>();

    public SparqlScriptProcessor(Function<? super Prologue, ? extends SparqlStmtParser> sparqlParserFactory, PrefixMapping globalPrefixes) {
        this.sparqlParserFactory = sparqlParserFactory;
        this.globalPrefixes = globalPrefixes;
    }

    public void addPostTransformer(Function<? super SparqlStmt, ? extends SparqlStmt> transformer) {
        this.postTransformers.add(transformer);
    }

    public void addPostMutator(Consumer<? super SparqlStmt> mutator) {
        this.postTransformers.add(stmt -> {
            mutator.accept((SparqlStmt)stmt);
            return stmt;
        });
    }

    public List<Map.Entry<SparqlStmt, Provenance>> getSparqlStmts() {
        return this.sparqlStmts;
    }

    public List<SparqlStmt> getPlainSparqlStmts() {
        return Lists.transform(this.sparqlStmts, Map.Entry::getKey);
    }

    public SparqlStmtParser getSparqlParser() {
        return this.sparqlParserFactory.apply((Prologue)new Prologue(this.globalPrefixes));
    }

    public static SparqlStmtParser createParserPlain(Prologue prologue, String base) {
        SparqlQueryParserWrapperSelectShortForm queryParser = SparqlQueryParserWrapperSelectShortForm.wrap((Function)SparqlQueryParserImpl.create((Syntax)Syntax.syntaxARQ, (Prologue)prologue, (String)base, null));
        SparqlUpdateParserImpl updateParser = SparqlUpdateParserImpl.create((Syntax)Syntax.syntaxARQ, (Prologue)prologue, (String)base, null);
        return new SparqlStmtParserImpl((SparqlQueryParser)queryParser, (SparqlUpdateParser)updateParser, base, true);
    }

    public static SparqlStmtParser createParserWithEnvSubstitution(Prologue prologue) {
        return SparqlScriptProcessor.createParserWithEnvSubstitution(prologue, System::getenv);
    }

    public static SparqlStmtParser createParserWithEnvSubstitution(Prologue prologue, Function<String, String> lookup) {
        SparqlStmtParser core = SparqlScriptProcessor.createParserPlain(prologue, prologue.getBaseURI());
        SparqlStmtParser sparqlParser = SparqlStmtParser.wrapWithTransform((Function)core, stmt -> SparqlStmtUtils.applyNodeTransform((SparqlStmt)stmt, x -> NodeEnvsubst.subst((Node)x, (Function)lookup)));
        return sparqlParser;
    }

    public static SparqlScriptProcessor createWithEnvSubstitution(PrefixMapping globalPrefixes) {
        if (globalPrefixes == null) {
            globalPrefixes = new PrefixMappingImpl();
        }
        return SparqlScriptProcessor.createWithEnvSubstitution(globalPrefixes, System::getenv);
    }

    public static SparqlScriptProcessor createWithEnvSubstitution(PrefixMapping globalPrefixes, Function<String, String> lookup) {
        SparqlScriptProcessor result = new SparqlScriptProcessor(prologue -> SparqlScriptProcessor.createParserWithEnvSubstitution(prologue, lookup), globalPrefixes);
        return result;
    }

    public static SparqlScriptProcessor createPlain(PrefixMapping globalPrefixes, String base) {
        SparqlScriptProcessor result = new SparqlScriptProcessor(prologue -> SparqlScriptProcessor.createParserPlain(prologue, base), globalPrefixes);
        return result;
    }

    public void process(List<String> filenames) {
        int i = 1;
        for (String filename : filenames) {
            this.process(i++, filename);
        }
    }

    public void processPaths(Collection<Path> paths) {
        int i = 1;
        for (Path path : paths) {
            this.process(i++, path);
        }
    }

    public void process(int index, Path path) {
        logger.info("Interpreting path" + (String)(index >= 0 ? " #" + index : "") + ": '" + String.valueOf(path) + "'");
        List stmts = SparqlStmtMgr.loadSparqlStmts((Path)path, (SparqlStmtParser)this.getSparqlParser());
        for (SparqlStmt stmt : stmts) {
            this.sparqlStmts.add(new AbstractMap.SimpleEntry<SparqlStmt, Provenance>(stmt, new Provenance(path.toString())));
        }
    }

    public void process(String filename) {
        this.process(-1, filename);
    }

    public void process(int index, String filename) {
        this.process(index, filename, this.sparqlStmts);
    }

    public SparqlStmtParser createParser(String baseIri) {
        IRIxResolver resolver = IRIxResolver.create((String)baseIri).allowRelative(true).build();
        Prologue prologue = new Prologue((PrefixMapping)(this.globalPrefixes == null ? new PrefixMappingImpl() : this.globalPrefixes), resolver);
        SparqlStmtParser result = this.sparqlParserFactory.apply((Prologue)prologue);
        return result;
    }

    public void process(int index, String filename, List<Map.Entry<SparqlStmt, Provenance>> result) {
        logger.info("Interpreting argument" + (String)(index >= 0 ? " #" + index : "") + ": '" + filename + "'");
        if (filename.startsWith(cwdKey)) {
            String cwdValue = filename.substring(cwdKey.length()).trim();
            if (this.cwd == null) {
                this.cwd = Paths.get(StandardSystemProperty.USER_DIR.value(), new String[0]);
            }
            this.cwd = this.cwd.resolve(cwdValue);
            logger.info("Pinned working directory to " + String.valueOf(this.cwd));
        } else if (filename.equals(cwdResetCwd)) {
            logger.info("Unpinned working directory");
            this.cwd = null;
        } else if (filename.startsWith(graphKey)) {
            boolean isForcedName = false;
            String targetGraphStr = filename.substring(graphKey.length()).trim();
            if (targetGraphStr != null && targetGraphStr.isEmpty()) {
                targetGraphStr = null;
            }
            if (targetGraphStr != null) {
                isForcedName = targetGraphStr.startsWith("!");
                if (isForcedName) {
                    if ((targetGraphStr = targetGraphStr.substring(1, targetGraphStr.length()).trim()).isEmpty()) {
                        throw new RuntimeException("Cannot force an empty graph name.");
                    }
                } else {
                    String tmp = targetGraphStr;
                    boolean needsForce = Stream.of("'", "\"", "`").anyMatch(c -> tmp.startsWith((String)c) || tmp.endsWith((String)c));
                    if (needsForce) {
                        throw new RuntimeException("Graph name starts or ends with likely unintended character. Prepend ! to force anway: !" + targetGraphStr);
                    }
                }
                this.targetGraph = NodeFactory.createURI((String)targetGraphStr);
            } else {
                this.targetGraph = null;
            }
            logger.info("Pinned target graph to " + String.valueOf(this.targetGraph) + (isForcedName ? " (forced) " : ""));
        } else if (filename.equals(graphResetKey)) {
            this.targetGraph = null;
            logger.info("Unpinned target graph");
        } else {
            ArrayList<Map.Entry<Lang, Throwable>> rdfErrorCollector;
            boolean isProcessed;
            block42: {
                isProcessed = false;
                rdfErrorCollector = new ArrayList<Map.Entry<Lang, Throwable>>();
                try {
                    Provenance prov = new Provenance(filename);
                    UpdateRequest ur = SparqlScriptProcessor.tryLoadFileAsUpdateRequest(filename, this.targetGraph, this.globalPrefixes, rdfErrorCollector);
                    if (ur != null) {
                        result.add(new AbstractMap.SimpleEntry<SparqlStmtUpdate, Provenance>(new SparqlStmtUpdate(ur), prov));
                        isProcessed = true;
                    }
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block42;
                    logger.debug("Probing verdict is 'not an RDF file' for " + filename, (Throwable)e);
                }
            }
            ArrayList<Throwable> stmtErrorCollector = new ArrayList<Throwable>();
            if (!isProcessed) {
                String baseIri = this.cwd == null ? null : this.cwd.toUri().toString();
                try {
                    SparqlStmtIterator it;
                    SparqlStmtParser sparqlParser;
                    TypedInputStream tmpIn = null;
                    try {
                        tmpIn = SparqlStmtUtils.openInputStream((String)filename);
                        if (tmpIn == null) {
                            throw new FileSystemException(filename);
                        }
                        sparqlParser = this.createParser(baseIri != null ? baseIri : tmpIn.getBaseURI());
                        it = SparqlStmtUtils.parse((InputStream)tmpIn, (Function)sparqlParser);
                        it.hasNext();
                        logger.debug("Attempting to interpret argument as a file containing sparql statements");
                    }
                    catch (Exception e) {
                        stmtErrorCollector.add(e);
                        try {
                            if (tmpIn != null) {
                                tmpIn.close();
                            }
                            tmpIn = new TypedInputStream((InputStream)new ByteArrayInputStream(filename.getBytes()), null, null);
                            sparqlParser = this.createParser(baseIri != null ? baseIri : tmpIn.getBaseURI());
                            it = SparqlStmtUtils.parse((InputStream)tmpIn, (Function)sparqlParser);
                            it.hasNext();
                        }
                        catch (Exception f) {
                            stmtErrorCollector.add(f);
                            Throwable cause = f.getCause();
                            if (!SparqlStmtUtils.isEncounteredSlashException((Throwable)cause)) {
                                throw new RuntimeException(filename + " could not be opened and failed to parse as SPARQL query", f);
                            }
                            throw new RuntimeException("Could not parse " + filename, e);
                        }
                    }
                    try (TypedInputStream in = tmpIn;){
                        SparqlStmtIterator itWithPos;
                        String sourceLocation = in.getBaseURI();
                        String sourceNamespace = sourceLocation == null ? null : SplitIRI.namespace((String)sourceLocation);
                        String sourceLocalName = sourceLocation == null ? null : SplitIRI.localname((String)sourceLocation);
                        String effNamespace = this.cwd == null ? sourceNamespace : this.cwd.toUri().toString();
                        SparqlStmtIterator sparqlStmtIterator = itWithPos = it instanceof SparqlStmtIterator ? it : null;
                        while (it.hasNext()) {
                            PrefixMapping stmtPrefixes;
                            Provenance prov;
                            if (itWithPos != null) {
                                prov = new Provenance(filename, Long.valueOf(itWithPos.getLine()), Long.valueOf(itWithPos.getColumn()));
                                logger.info("Preparing SPARQL statement at line " + itWithPos.getLine() + ", column " + itWithPos.getColumn());
                            } else {
                                prov = new Provenance(filename);
                                logger.info("Preparing inline SPARQL argument " + filename);
                            }
                            prov.setSourceLocation(sourceLocation);
                            prov.setSourceNamespace(effNamespace);
                            prov.setSourceLocalName(sourceLocalName);
                            SparqlStmt stmt = (SparqlStmt)it.next();
                            if (!stmt.isParsed()) {
                                throw new RuntimeException((Throwable)stmt.getParseException());
                            }
                            if (this.globalPrefixes != null && (stmtPrefixes = stmt.getPrefixMapping()) != null) {
                                this.globalPrefixes.setNsPrefixes(stmtPrefixes);
                            }
                            for (Function<? super SparqlStmt, ? extends SparqlStmt> postTransformer : this.postTransformers) {
                                SparqlStmt tmp = postTransformer.apply((SparqlStmt)stmt);
                                stmt = Objects.requireNonNull(tmp, "Transformations yeld null " + String.valueOf(postTransformer));
                            }
                            result.add(new AbstractMap.SimpleEntry<SparqlStmt, Provenance>(stmt, prov));
                        }
                    }
                }
                catch (Exception e) {
                    if (e.getCause() != null && stmtErrorCollector.contains(e.getCause())) {
                        stmtErrorCollector.remove(e.getCause());
                    }
                    stmtErrorCollector.add(e);
                    String message = "Failed to process argument" + (String)(index >= 0 ? " #" + index : "") + ": " + filename;
                    MultiException multiException = new MultiException(message, rdfErrorCollector, stmtErrorCollector);
                    throw new RuntimeException(message, multiException);
                }
            }
        }
    }

    public static UpdateRequest tryLoadFileAsUpdateRequest(String filename, Node targetGraph, PrefixMapping globalPrefixes, Collection<Map.Entry<Lang, Throwable>> errorCollector) throws IOException {
        UpdateRequest result = null;
        try (TypedInputStream tmpIn = RDFDataMgrEx.open(filename, Arrays.asList(Lang.TRIG, Lang.NQUADS, Lang.JSONLD, Lang.RDFXML), errorCollector);){
            Lang rdfLang;
            InputStream in = tmpIn.getInputStream();
            String contentType = tmpIn.getContentType();
            if (contentType == null) {
                if (logger.isInfoEnabled()) {
                    logger.info("Argument does not appear to be (RDF) data because content type probing yeld no result");
                }
            } else if (logger.isInfoEnabled()) {
                logger.info("Detected data format: " + contentType);
            }
            Lang lang = rdfLang = contentType == null ? null : RDFLanguages.contentTypeToLang((String)contentType);
            if (rdfLang != null) {
                Lang finalLang;
                if (RDFLanguages.isTriples((Lang)rdfLang)) {
                    finalLang = Lang.TTL;
                } else if (RDFLanguages.isQuads((Lang)rdfLang)) {
                    finalLang = Lang.TRIG;
                } else {
                    throw new RuntimeException("Unknown lang: " + String.valueOf(rdfLang));
                }
                PrefixMap newPrefixes = PrefixUtils.readPrefixes(null, (InputStream)in, (Lang)finalLang);
                if (logger.isInfoEnabled()) {
                    logger.info("A total of " + newPrefixes.size() + " prefixes known after processing " + filename);
                }
                globalPrefixes.setNsPrefixes(newPrefixes.getMapping());
                result = new UpdateRequest((Update)new UpdateLoad(filename, targetGraph));
            }
        }
        return result;
    }

    public static class Provenance {
        protected String sourceLocation;
        protected String sourceNamespace;
        protected String sourceLocalName;
        protected String argStr;
        protected Long line;
        protected Long column;

        public Provenance(String arg) {
            this(arg, null, null);
        }

        public Provenance(String argStr, Long line, Long column) {
            this.argStr = argStr;
            this.line = line;
            this.column = column;
            this.sourceLocation = null;
        }

        public String getSourceLocation() {
            return this.sourceLocation;
        }

        public void setSourceLocation(String sparqlPath) {
            this.sourceLocation = sparqlPath;
        }

        public String getSourceNamespace() {
            return this.sourceNamespace;
        }

        public void setSourceNamespace(String sourceNamespace) {
            this.sourceNamespace = sourceNamespace;
        }

        public String getSourceLocalName() {
            return this.sourceLocalName;
        }

        public void setSourceLocalName(String sourceLocalName) {
            this.sourceLocalName = sourceLocalName;
        }

        public String toString() {
            String result = this.argStr + (String)(this.line == null ? (this.column == null ? "" : ":") : ":" + this.line) + (String)(this.column == null ? "" : ":" + this.column);
            return result;
        }
    }
}

