/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx.script;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.aksw.jena_sparql_api.rx.script.SimpleResource;

public class SimpleResourceFromPath
extends SimpleResource {
    private final Path path;

    public SimpleResourceFromPath(Path path) {
        this.path = Objects.requireNonNull(path);
    }

    @Override
    public String getQualifiedName() {
        return this.path.toString();
    }

    @Override
    public String getLocalName() {
        return this.path.getFileName().toString();
    }

    @Override
    public InputStream open() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleResourceFromPath other = (SimpleResourceFromPath)obj;
        return Objects.equals(this.path, other.path);
    }
}

