/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx.script;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.Resource;
import io.github.classgraph.ResourceList;
import io.github.classgraph.ScanResult;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.aksw.jena_sparql_api.rx.script.SimpleResource;
import org.aksw.jena_sparql_api.rx.script.SimpleResourceFromClassGraphResource;
import org.aksw.jena_sparql_api.rx.script.SimpleResourceFromPath;
import org.apache.commons.lang3.StringUtils;

public class ResourceResolver {
    public static List<String> resolveClassPathResources(String glob) {
        String normalized = glob.replace('\\', '/');
        String prefix = ResourceResolver.longestLiteralPrefix(normalized);
        normalized = normalized.replaceAll("^//+", "");
        ArrayList<String> result = new ArrayList<String>();
        try (ScanResult scanResult = new ClassGraph().acceptPaths(new String[]{prefix}).scan();){
            ResourceList resourceList = scanResult.getResourcesMatchingWildcard(normalized);
            for (Resource r : resourceList) {
                result.add(r.getPath());
            }
        }
        Collections.sort(result);
        return result;
    }

    public static List<SimpleResource> resolveResources(String pathPattern) throws IOException {
        boolean foundFsFiles;
        ArrayList<SimpleResource> result = new ArrayList<SimpleResource>();
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + pathPattern);
        try (Stream<Path> files = Files.walk(Paths.get(".", new String[0]), new FileVisitOption[0]);){
            for (Path path : files.toList()) {
                if (!matcher.matches(path) || !Files.isRegularFile(path, new LinkOption[0])) continue;
                result.add(new SimpleResourceFromPath(path));
            }
        }
        String normalized = pathPattern.replace('\\', '/');
        boolean bl = foundFsFiles = !result.isEmpty();
        if (!foundFsFiles) {
            String prefix = ResourceResolver.longestLiteralPrefix(normalized);
            normalized = normalized.replaceAll("^//+", "");
            try (ScanResult scanResult = new ClassGraph().acceptPaths(new String[]{prefix}).scan();){
                ResourceList resourceList = scanResult.getResourcesMatchingWildcard(normalized);
                for (Resource r : resourceList) {
                    result.add(new SimpleResourceFromClassGraphResource(r));
                }
            }
        }
        return result;
    }

    public static String longestLiteralPrefix(String glob) {
        int end;
        if (glob == null) {
            throw new NullPointerException("glob");
        }
        int cut = StringUtils.indexOfAny((CharSequence)glob, (char[])new char[]{'*', '?', '['});
        if (cut == -1) {
            cut = glob.length();
        }
        for (end = cut; end > 0 && glob.charAt(end - 1) == '/'; --end) {
        }
        String prefix = glob.substring(0, end);
        return prefix;
    }

    public static void main(String[] args) throws IOException {
        List<String> resolved = ResourceResolver.resolveClassPathResources("void/sportal/compact/*.rq");
        System.out.println(resolved);
        System.out.println("done.");
    }
}

