/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx.io.resultset;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.aksw.jena_sparql_api.rx.io.resultset.SinkStreamingBase;
import org.aksw.jena_sparql_api.rx.io.resultset.SinkStreamingStreamRDF;
import org.aksw.jenax.arq.dataset.orderaware.DatasetGraphFactoryEx;
import org.aksw.jenax.arq.util.prefix.PrefixUtils;
import org.aksw.jenax.arq.util.quad.DatasetGraphUtils;
import org.aksw.jenax.arq.util.quad.QuadUtils;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapAdapter;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFOps;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.DatasetGraph;

public class SinkStreamingDataset
extends SinkStreamingBase<Dataset> {
    protected SinkStreamingStreamRDF delegate;
    protected List<DatasetGraph> deferredData;
    protected boolean allowExtendBasePrefixes = true;
    protected PrefixMapping basePrefixes;
    protected PrefixMapping usedPrefixes = new PrefixMappingImpl();
    protected PrefixMap usedPrefixAdapter = new PrefixMapAdapter(this.usedPrefixes);
    protected long remainingDeferrals;

    public SinkStreamingDataset(SinkStreamingStreamRDF delegate, PrefixMapping basePrefixes, long remainingDeferrals, boolean allowExtendBasePrefixes) {
        this.delegate = delegate;
        this.deferredData = remainingDeferrals > 1L ? new ArrayList() : null;
        this.allowExtendBasePrefixes = allowExtendBasePrefixes;
        this.basePrefixes = new PrefixMappingImpl();
        this.basePrefixes.setNsPrefixes(basePrefixes);
        this.remainingDeferrals = remainingDeferrals;
    }

    public void flush() {
        this.delegate.flush();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public final void finishActual() {
        this.delegate.finish();
    }

    @Override
    protected void sendActual(Dataset item) {
        DatasetGraph dg = item.asDatasetGraph();
        if (this.remainingDeferrals > 0L) {
            if (this.allowExtendBasePrefixes) {
                this.basePrefixes.setNsPrefixes(item.getDefaultModel().getNsPrefixMap());
            }
            Streams.concat((Stream[])new Stream[]{Streams.stream((Iterator)dg.getDefaultGraph().find()).flatMap(TripleUtils::streamNodes), Streams.stream((Iterator)dg.find()).flatMap(QuadUtils::streamNodes)}).forEach(node -> PrefixUtils.usedPrefixes((Node)node, (PrefixMapping)this.basePrefixes, (PrefixMapping)this.usedPrefixes));
            --this.remainingDeferrals;
            if (this.remainingDeferrals == 0L) {
                StreamRDFOps.sendPrefixesToStream((PrefixMapping)this.usedPrefixes, (StreamRDF)this.delegate);
                for (DatasetGraph d : this.deferredData) {
                    StreamRDFOps.sendDatasetToStream((DatasetGraph)d, (StreamRDF)this.delegate, null, (PrefixMap)this.usedPrefixAdapter);
                }
                this.deferredData = null;
                StreamRDFOps.sendDatasetToStream((DatasetGraph)dg, (StreamRDF)this.delegate, null, (PrefixMap)this.usedPrefixAdapter);
            } else {
                DatasetGraph copy = DatasetGraphFactoryEx.createInsertOrderPreservingDatasetGraph();
                DatasetGraphUtils.addAll((DatasetGraph)copy, (DatasetGraph)dg);
                this.deferredData.add(copy);
            }
        } else {
            StreamRDFOps.sendDatasetToStream((DatasetGraph)dg, (StreamRDF)this.delegate, null, (PrefixMap)this.usedPrefixAdapter);
        }
    }
}

