package org.aksw.jena_sparql_api.rx.script;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;

public class SimpleResourceFromPath
    extends SimpleResource
{
    private final Path path;

    public SimpleResourceFromPath(Path path) {
        super();
        this.path = Objects.requireNonNull(path);
    }

    @Override
    public String getQualifiedName() {
        return path.toString();
    }

    @Override
    public String getLocalName() {
        return path.getFileName().toString();
    }

    @Override
    public InputStream open() throws IOException {
        return Files.newInputStream(path);
    }

    @Override
    public int hashCode() {
        return Objects.hash(path);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        SimpleResourceFromPath other = (SimpleResourceFromPath) obj;
        return Objects.equals(path, other.path);
    }
}
