package org.aksw.jena_sparql_api.rx.script;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

import io.github.classgraph.Resource;

public class SimpleResourceFromClassGraphResource
    extends SimpleResource
{
    private final Resource resource;

    public SimpleResourceFromClassGraphResource(Resource resource) {
        super();
        this.resource = Objects.requireNonNull(resource);
    }

    @Override
    public String getQualifiedName() {
        return resource.toString();
    }

    @Override
    public String getLocalName() {
        // TODO It seems we need to split by /
        return resource.getPath();
    }

    @Override
    public InputStream open() throws IOException {
        return resource.open();
    }

    @Override
    public int hashCode() {
        return Objects.hash(resource);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        SimpleResourceFromClassGraphResource other = (SimpleResourceFromClassGraphResource) obj;
        return Objects.equals(resource, other.resource);
    }
}
