package org.aksw.jena_sparql_api.rx.script;

import java.io.IOException;
import java.io.InputStream;

public abstract class SimpleResource implements Comparable<SimpleResource> {
    /** File name + path. */
    public abstract String getQualifiedName();

    /** Only the file name. */
    public abstract String getLocalName();

    public abstract InputStream open() throws IOException;

    @Override
    public int compareTo(SimpleResource other) {
        return this.getQualifiedName().compareTo(other.getQualifiedName());
    }

    @Override
    public String toString() {
        return this.getQualifiedName();
    }
}
