/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx.query_flow;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.FlowableEmitter;
import io.reactivex.rxjava3.core.FlowableTransformer;
import java.util.Collection;
import java.util.List;
import org.aksw.commons.rx.util.RxUtils;
import org.aksw.jena_sparql_api.rx.query_flow.QueryFlowBase;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;
import org.apache.jena.sparql.function.FunctionEnv;

public class QueryFlowGroupBy
extends QueryFlowBase<Binding> {
    protected VarExprList groupVarExpr;
    protected List<ExprAggregator> aggregators;
    protected boolean noInput = true;
    protected Multimap<Binding, Pair<Var, Accumulator>> accumulators = MultimapBuilder.hashKeys().arrayListValues().build();
    private static Pair<Var, Accumulator> placeholder = Pair.create((Object)null, (Object)null);

    public QueryFlowGroupBy(FlowableEmitter<Binding> emitter, FunctionEnv execCxt, VarExprList groupVarExpr, List<ExprAggregator> aggregators) {
        super(emitter, execCxt);
        this.groupVarExpr = groupVarExpr;
        this.aggregators = aggregators;
    }

    public void onNext(Binding b) {
        this.noInput = false;
        boolean hasAggregators = this.aggregators != null && !this.aggregators.isEmpty();
        boolean hasGroupBy = !this.groupVarExpr.isEmpty();
        Binding key = QueryFlowGroupBy.genKey(this.groupVarExpr, b, this.execCxt);
        if (!hasAggregators) {
            this.accumulators.put((Object)key, placeholder);
        }
        if (!this.accumulators.containsKey((Object)key)) {
            for (ExprAggregator agg : this.aggregators) {
                Accumulator x = agg.getAggregator().createAccumulator();
                Var v = agg.getVar();
                this.accumulators.put((Object)key, (Object)Pair.create((Object)v, (Object)x));
            }
        }
        for (Pair pair : this.accumulators.get((Object)key)) {
            ((Accumulator)pair.getRight()).accumulate(b, this.execCxt);
        }
    }

    public void onComplete() {
        boolean hasGroupBy;
        boolean hasAggregators = this.aggregators != null && !this.aggregators.isEmpty();
        boolean bl = hasGroupBy = !this.groupVarExpr.isEmpty();
        if (this.noInput) {
            if (hasGroupBy && !hasAggregators) {
                this.emitter.onNext((Object)BindingFactory.binding());
            }
            BindingBuilder builder = BindingFactory.builder();
            for (ExprAggregator agg : this.aggregators) {
                Node value = agg.getAggregator().getValueEmpty();
                if (value == null) continue;
                Var v = agg.getVar();
                builder.add(v, value);
            }
            Binding binding = builder.build();
            this.emitter.onNext((Object)binding);
        }
        for (Binding k : this.accumulators.keySet()) {
            Collection accs = this.accumulators.get((Object)k);
            BindingBuilder b = BindingFactory.builder((Binding)k);
            for (Pair pair : accs) {
                NodeValue value = ((Accumulator)pair.getRight()).getValue();
                if (value == null) continue;
                Var v = (Var)pair.getLeft();
                b.add(v, value.asNode());
            }
            this.emitter.onNext((Object)b.build());
        }
        this.emitter.onComplete();
    }

    private static Binding genKey(VarExprList vars, Binding binding, FunctionEnv execCxt) {
        return QueryFlowGroupBy.copyProject(vars, binding, execCxt);
    }

    private static Binding copyProject(VarExprList vars, Binding binding, FunctionEnv execCxt) {
        BindingBuilder x = BindingBuilder.create();
        for (Var var : vars.getVars()) {
            Node node = vars.get(var, binding, execCxt);
            if (node == null) continue;
            x.add(var, node);
        }
        return x.build();
    }

    public static FlowableTransformer<Binding, Binding> createTransformer(FunctionEnv execCxt, VarExprList groupVarExpr, List<ExprAggregator> aggregators) {
        return RxUtils.createTransformer(emitter -> new QueryFlowGroupBy((FlowableEmitter<Binding>)emitter, execCxt, groupVarExpr, aggregators), (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }
}

