/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx.io.resultset;

import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.aksw.commons.io.util.StdIo;
import org.aksw.jena_sparql_api.rx.io.resultset.OutputFormatSpec;
import org.aksw.jena_sparql_api.rx.io.resultset.OutputMode;
import org.aksw.jena_sparql_api.rx.io.resultset.SPARQLResultExProcessor;
import org.aksw.jena_sparql_api.rx.io.resultset.SPARQLResultExProcessorForwarding;
import org.aksw.jena_sparql_api.rx.io.resultset.SPARQLResultExProcessorImpl;
import org.aksw.jena_sparql_api.rx.io.resultset.SinkStreamingAdapter;
import org.aksw.jena_sparql_api.rx.io.resultset.SinkStreamingBinding;
import org.aksw.jena_sparql_api.rx.io.resultset.SinkStreamingJsonArray;
import org.aksw.jena_sparql_api.rx.io.resultset.SinkStreamingQuads;
import org.aksw.jenax.arq.dataset.orderaware.DatasetFactoryEx;
import org.aksw.jenax.arq.json.RdfJsonUtils;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.util.SparqlStmtUtils;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.ResultSetMgr;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Var;

public class SPARQLResultExProcessorBuilder {
    protected OutputMode outputMode;
    protected Supplier<? extends OutputStream> out;
    protected Supplier<? extends OutputStream> err;
    protected String outFormat;
    protected PrefixMapping prefixMapping;
    protected RDFFormat tripleFormat;
    protected RDFFormat quadFormat;
    protected long deferCount;
    protected boolean jqMode;
    protected int jqDepth;
    protected boolean jqFlatMode;
    protected Closeable closeAction;
    protected Collection<? extends SparqlStmt> stmts;

    public Supplier<? extends OutputStream> getOut() {
        return this.out;
    }

    public OutputMode getOutputMode() {
        return this.outputMode;
    }

    public SPARQLResultExProcessorBuilder setOutputMode(OutputMode outputMode) {
        this.outputMode = outputMode;
        return this;
    }

    public SPARQLResultExProcessorBuilder setOut(Supplier<? extends OutputStream> out) {
        this.out = out;
        return this;
    }

    public Supplier<? extends OutputStream> getErr() {
        return this.err;
    }

    public SPARQLResultExProcessorBuilder setErr(Supplier<? extends OutputStream> err) {
        this.err = err;
        return this;
    }

    public String getOutFormat() {
        return this.outFormat;
    }

    public SPARQLResultExProcessorBuilder setOutFormat(String outFormat) {
        this.outFormat = outFormat;
        return this;
    }

    public PrefixMapping getPrefixMapping() {
        return this.prefixMapping;
    }

    public SPARQLResultExProcessorBuilder setPrefixMapping(PrefixMapping prefixMapping) {
        this.prefixMapping = prefixMapping;
        return this;
    }

    public RDFFormat getTripleFormat() {
        return this.tripleFormat;
    }

    public SPARQLResultExProcessorBuilder setTripleFormat(RDFFormat tripleFormat) {
        this.tripleFormat = tripleFormat;
        return this;
    }

    public RDFFormat getQuadFormat() {
        return this.quadFormat;
    }

    public SPARQLResultExProcessorBuilder setQuadFormat(RDFFormat quadFormat) {
        this.quadFormat = quadFormat;
        return this;
    }

    public long getDeferCount() {
        return this.deferCount;
    }

    public SPARQLResultExProcessorBuilder setDeferCount(long deferCount) {
        this.deferCount = deferCount;
        return this;
    }

    public boolean isJqMode() {
        return this.jqMode;
    }

    public SPARQLResultExProcessorBuilder setJqMode(boolean jqMode) {
        this.jqMode = jqMode;
        return this;
    }

    public int getJqDepth() {
        return this.jqDepth;
    }

    public SPARQLResultExProcessorBuilder setJqDepth(int jqDepth) {
        this.jqDepth = jqDepth;
        return this;
    }

    public boolean isJqFlatMode() {
        return this.jqFlatMode;
    }

    public SPARQLResultExProcessorBuilder setJqFlatMode(boolean jqFlatMode) {
        this.jqFlatMode = jqFlatMode;
        return this;
    }

    public Closeable getCloseAction() {
        return this.closeAction;
    }

    public SPARQLResultExProcessorBuilder setCloseAction(Closeable closeAction) {
        this.closeAction = closeAction;
        return this;
    }

    public Collection<? extends SparqlStmt> getStmts() {
        return this.stmts;
    }

    public SPARQLResultExProcessorBuilder setStmts(Collection<? extends SparqlStmt> stmts) {
        this.stmts = stmts;
        return this;
    }

    public SPARQLResultExProcessor build() {
        return SPARQLResultExProcessorBuilder.configureProcessor(this.out.get(), this.err.get(), this.outFormat, this.stmts == null ? Collections.emptyList() : this.stmts, this.prefixMapping, this.tripleFormat, this.quadFormat, this.deferCount, this.jqMode, this.jqDepth, this.jqFlatMode, this.closeAction);
    }

    public static SPARQLResultExProcessorBuilder create() {
        SPARQLResultExProcessorBuilder result = new SPARQLResultExProcessorBuilder();
        result.setOut(() -> StdIo.openStdOutWithCloseShield()).setErr(() -> StdIo.openStdErrWithCloseShield()).setDeferCount(20L).setTripleFormat(RDFFormat.TURTLE_BLOCKS).setQuadFormat(RDFFormat.TRIG_BLOCKS).setJqMode(false).setJqDepth(3).setJqFlatMode(false);
        return result;
    }

    public static SPARQLResultExProcessorBuilder createForQuadOutput() {
        return SPARQLResultExProcessorBuilder.create().setOutputMode(OutputMode.QUAD);
    }

    public static SPARQLResultExProcessor configureProcessor(OutputStream out, OutputStream err, String outFormat, Collection<? extends SparqlStmt> stmts, PrefixMapping prefixMapping, RDFFormat tripleFormat, RDFFormat quadFormat, long deferCount, boolean jqMode, final int jqDepth, final boolean jqFlatMode, Closeable closeAction) {
        OutputFormatSpec spec = OutputFormatSpec.create(outFormat, tripleFormat, quadFormat, stmts, jqMode);
        List selectVars = SparqlStmtUtils.getUnionProjectVars(stmts);
        final SPARQLResultExProcessorImpl coreProcessor = SPARQLResultExProcessorBuilder.configureForOutputMode(spec.getOutputMode(), out, err, prefixMapping, spec.getOutRdfFormat(), deferCount, spec.getOutLang(), selectVars, closeAction);
        SPARQLResultExProcessor effectiveProcessor = jqMode ? new SPARQLResultExProcessorForwarding<SPARQLResultExProcessorImpl>(coreProcessor){

            @Override
            public Void onResultSet(ResultSet it) {
                while (it.hasNext()) {
                    QuerySolution qs = it.next();
                    JsonObject json = RdfJsonUtils.toJson((QuerySolution)qs, (int)jqDepth, (boolean)jqFlatMode);
                    coreProcessor.getJsonSink().send((Object)json);
                }
                return null;
            }
        } : coreProcessor;
        return effectiveProcessor;
    }

    public static SPARQLResultExProcessorImpl configureForOutputMode(OutputMode outputMode, OutputStream out, final OutputStream err, PrefixMapping pm, RDFFormat outRdfFormat, long deferCount, Lang outLang, List<Var> resultSetVars, Closeable closeAction) {
        Supplier<Dataset> datasetSupp = () -> DatasetFactoryEx.createInsertOrderPreservingDataset();
        return switch (outputMode) {
            case OutputMode.TRIPLE, OutputMode.QUAD -> {
                Objects.requireNonNull(outRdfFormat);
                yield new SPARQLResultExProcessorImpl(SinkStreamingQuads.createSinkQuads(outRdfFormat, out, pm, deferCount, datasetSupp), new SinkStreamingJsonArray(err, false), new SinkStreamingAdapter(), closeAction){

                    @Override
                    public Void onResultSet(ResultSet rs) {
                        ResultSetMgr.write((OutputStream)err, (ResultSet)rs, (Lang)ResultSetLang.RS_Text);
                        return null;
                    }
                };
            }
            case OutputMode.JSON -> new SPARQLResultExProcessorImpl(SinkStreamingQuads.createSinkQuads(RDFFormat.TRIG_BLOCKS, err, pm, 0L, datasetSupp), new SinkStreamingJsonArray(out), new SinkStreamingAdapter(), closeAction){

                @Override
                public Void onResultSet(ResultSet rs) {
                    ResultSetMgr.write((OutputStream)err, (ResultSet)rs, (Lang)ResultSetLang.RS_Text);
                    return null;
                }
            };
            case OutputMode.BINDING -> {
                Objects.requireNonNull(outLang);
                yield new SPARQLResultExProcessorImpl(SinkStreamingQuads.createSinkQuads(RDFFormat.TRIG_BLOCKS, err, pm, 0L, datasetSupp), new SinkStreamingJsonArray(err, false), new SinkStreamingBinding(out, resultSetVars, outLang), closeAction);
            }
            default -> throw new IllegalArgumentException("Unknown output mode: " + String.valueOf((Object)outputMode));
        };
    }
}

