/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx.io.resultset;

import com.google.common.collect.Iterators;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.aksw.jena_sparql_api.rx.io.resultset.SPARQLResultExProcessor;
import org.aksw.jena_sparql_api.rx.io.resultset.SinkStreaming;
import org.aksw.jena_sparql_api.rx.io.resultset.SinkStreamingBase;
import org.aksw.jenax.stmt.resultset.SPARQLResultEx;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.resultset.SPARQLResult;

public class SPARQLResultExProcessorImpl
extends SinkStreamingBase<SPARQLResultEx>
implements SPARQLResultExProcessor {
    protected Gson gson = new Gson();
    protected SinkStreaming<Quad> quadSink;
    protected SinkStreaming<JsonElement> jsonSink;
    protected SinkStreaming<Binding> bindingSink;
    protected Closeable closeAction;

    public SPARQLResultExProcessorImpl(SinkStreaming<Quad> quadSink, SinkStreaming<JsonElement> jsonSink, SinkStreaming<Binding> bindingSink, Closeable closeAction) {
        this.quadSink = quadSink;
        this.jsonSink = jsonSink;
        this.bindingSink = bindingSink;
        this.closeAction = closeAction;
    }

    public Sink<Quad> getQuadSink() {
        return this.quadSink;
    }

    public SinkStreaming<Binding> getBindingSink() {
        return this.bindingSink;
    }

    public Sink<JsonElement> getJsonSink() {
        return this.jsonSink;
    }

    @Override
    public Void onBooleanResult(Boolean value) {
        throw new UnsupportedOperationException("Boolean results not supported");
    }

    @Override
    public Void onResultSet(ResultSet rs) {
        while (rs.hasNext()) {
            Binding binding = rs.nextBinding();
            this.bindingSink.send(binding);
        }
        return null;
    }

    @Override
    public Void onJsonItems(Iterator<JsonObject> it) {
        while (it.hasNext()) {
            JsonObject json = it.next();
            String jsonStr = json.toString();
            JsonElement el = (JsonElement)this.gson.fromJson(jsonStr, JsonElement.class);
            this.jsonSink.send(el);
        }
        return null;
    }

    @Override
    public Void onQuads(Iterator<Quad> it) {
        while (it.hasNext()) {
            Quad quad = it.next();
            this.quadSink.send(quad);
        }
        return null;
    }

    @Override
    public Void onTriples(Iterator<Triple> it) {
        return this.onQuads(Iterators.transform(it, t -> new Quad(Quad.defaultGraphIRI, t)));
    }

    @Override
    protected void startActual() {
        this.quadSink.start();
        this.bindingSink.start();
        this.jsonSink.start();
    }

    @Override
    protected void finishActual() {
        this.jsonSink.finish();
        this.bindingSink.finish();
        this.quadSink.finish();
    }

    @Override
    protected void sendActual(SPARQLResultEx item) {
        this.forward((SPARQLResult)item);
    }

    public void flush() {
        this.quadSink.flush();
        this.bindingSink.flush();
        this.jsonSink.flush();
    }

    @Override
    public void close() {
        this.quadSink.close();
        this.bindingSink.close();
        this.jsonSink.close();
        if (this.closeAction != null) {
            try {
                this.closeAction.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

