/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx.io.resultset;

import com.google.common.collect.Iterables;
import java.util.Collection;
import org.aksw.jena_sparql_api.rx.io.resultset.OutputMode;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.apache.jena.query.Query;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.resultset.ResultSetWriterRegistry;

public class OutputModes {
    public static OutputMode detectOutputMode(Collection<? extends SparqlStmt> stmts) {
        OutputMode result = null;
        if (stmts.isEmpty()) {
            result = OutputMode.TRIPLE;
        } else {
            Query q;
            SparqlStmt last = (SparqlStmt)Iterables.getLast(stmts);
            if (last.isQuery() && (q = last.getQuery()).isJsonType()) {
                result = OutputMode.JSON;
            }
            int tripleCount = 0;
            int quadCount = 0;
            int bindingCount = 0;
            if (result == null) {
                for (SparqlStmt sparqlStmt : stmts) {
                    if (!sparqlStmt.isQuery()) continue;
                    Query q2 = sparqlStmt.getQuery();
                    if (q2.isConstructType()) {
                        if (q2.isConstructQuad()) {
                            ++quadCount;
                            continue;
                        }
                        ++tripleCount;
                        continue;
                    }
                    if (!q2.isSelectType()) continue;
                    ++bindingCount;
                }
                if (quadCount != 0) {
                    result = OutputMode.QUAD;
                } else if (tripleCount != 0) {
                    result = OutputMode.TRIPLE;
                } else if (bindingCount != 0) {
                    result = OutputMode.BINDING;
                }
            }
            if (result == null) {
                result = OutputMode.TRIPLE;
            }
        }
        return result;
    }

    public static OutputMode determineOutputMode(Lang lang) {
        OutputMode result = RDFLanguages.isTriples((Lang)lang) || RDFLanguages.isQuads((Lang)lang) ? OutputMode.QUAD : (ResultSetWriterRegistry.isRegistered((Lang)lang) ? OutputMode.BINDING : null);
        return result;
    }
}

