/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx.io.resultset;

import com.google.common.base.Strings;
import io.reactivex.rxjava3.core.Flowable;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.commons.io.util.StdIo;
import org.aksw.commons.rx.op.RxOps;
import org.aksw.commons.rx.util.RxUtils;
import org.aksw.jena_sparql_api.rx.io.resultset.OutputMode;
import org.aksw.jena_sparql_api.rx.io.resultset.OutputModes;
import org.aksw.jena_sparql_api.rx.io.resultset.SPARQLResultExProcessor;
import org.aksw.jena_sparql_api.rx.io.resultset.SPARQLResultExProcessorBuilder;
import org.aksw.jena_sparql_api.rx.io.resultset.SparqlMappers;
import org.aksw.jena_sparql_api.rx.script.SparqlScriptProcessor;
import org.aksw.jenax.arq.util.node.NodeTransformLib2;
import org.aksw.jenax.sparql.query.rx.RDFDataMgrEx;
import org.aksw.jenax.sparql.query.rx.RDFDataMgrRx;
import org.aksw.jenax.sparql.query.rx.StreamUtils;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.resultset.SPARQLResultEx;
import org.aksw.jenax.stmt.util.SparqlStmtUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.TransformUnionQuery;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.exec.http.Service;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedGraphStreamCliUtils {
    private static final Logger logger = LoggerFactory.getLogger(NamedGraphStreamCliUtils.class);

    public static void validateStdIn(List<String> args) {
        long stdInCount = args.stream().filter(item -> item.equals("-")).count();
        if (stdInCount != 0L && args.size() > 1) {
            throw new RuntimeException("If STDIN (denoted by '-') is used no further input sources may be used");
        }
    }

    public static Callable<TypedInputStream> validate(String filenameOrIri, Iterable<Lang> probeLangs, boolean displayProbeResult) {
        Callable<TypedInputStream> result;
        if (RDFDataMgrEx.isStdIn(filenameOrIri)) {
            TypedInputStream tin = RDFDataMgrEx.forceBuffered(RDFDataMgrEx.open(filenameOrIri, probeLangs));
            result = () -> RDFDataMgrEx.wrapInputStream((InputStream)new CloseShieldInputStream(tin.getInputStream()), tin);
        } else {
            try (TypedInputStream tin = RDFDataMgrEx.open(filenameOrIri, probeLangs);){
                String ct = tin.getContentType();
                Lang lang = RDFLanguages.contentTypeToLang((String)ct);
                if (displayProbeResult) {
                    logger.info("Detected format: " + filenameOrIri + " " + ct);
                }
                result = () -> RDFDataMgrEx.forceBuffered(RDFDataMgrEx.open(filenameOrIri, Arrays.asList(lang)));
            }
        }
        return result;
    }

    public static List<String> preprocessArgs(List<String> args) {
        List<String> result = args.isEmpty() ? Collections.singletonList("-") : args;
        NamedGraphStreamCliUtils.validateStdIn(args);
        return result;
    }

    public static Flowable<Dataset> createNamedGraphStreamFromArgs(List<String> rawArgs, String fmtHint, PrefixMapping pm, Collection<Lang> quadLangs) {
        List<String> args = NamedGraphStreamCliUtils.preprocessArgs(rawArgs);
        Map<String, Callable<TypedInputStream>> map = NamedGraphStreamCliUtils.validate(args, quadLangs, true);
        Flowable result = Flowable.fromIterable(map.entrySet()).concatMap(arg -> {
            String argName = (String)arg.getKey();
            logger.info("Loading stream for arg " + argName);
            Callable inSupp = (Callable)arg.getValue();
            Flowable r = RDFDataMgrRx.createFlowableDatasets(inSupp).map(ds -> NodeTransformLib2.applyNodeTransform(StreamUtils::decodeDistinguished, (Dataset)ds));
            return r;
        });
        return result;
    }

    public static Map<String, Callable<TypedInputStream>> validate(List<String> args, Iterable<Lang> probeLangs, boolean displayProbeResults) {
        LinkedHashMap<String, Callable<TypedInputStream>> result = new LinkedHashMap<String, Callable<TypedInputStream>>();
        NamedGraphStreamCliUtils.validateStdIn(args);
        int violationCount = 0;
        for (String arg : args) {
            try {
                Callable<TypedInputStream> inSupp = NamedGraphStreamCliUtils.validate(arg, probeLangs, displayProbeResults);
                result.put(arg, inSupp);
            }
            catch (Exception e) {
                String msg = ExceptionUtils.getRootCauseMessage((Throwable)e);
                logger.info(arg + ": " + msg);
                ++violationCount;
            }
        }
        if (violationCount != 0) {
            throw new IllegalArgumentException("Some arguments failed to validate");
        }
        return result;
    }

    public static void execMap(PrefixMapping pm, List<String> sourceStrs, Collection<Lang> quadLangs, List<String> stmtStrs, String timeoutSpec, String outFormat, long deferCount) {
        Consumer<Context> contextMutator = cxt -> {
            if (!Strings.isNullOrEmpty((String)timeoutSpec)) {
                cxt.set(Service.httpQueryTimeout, (Object)timeoutSpec);
            }
        };
        SparqlScriptProcessor scriptProcessor = SparqlScriptProcessor.createWithEnvSubstitution(pm);
        scriptProcessor.addPostTransformer(stmt -> SparqlStmtUtils.applyOpTransform((SparqlStmt)stmt, op -> Transformer.transformSkipService((Transform)new TransformUnionQuery(), (Op)op)));
        scriptProcessor.process(stmtStrs);
        List<Map.Entry<SparqlStmt, SparqlScriptProcessor.Provenance>> workloads = scriptProcessor.getSparqlStmts();
        List stmts = workloads.stream().map(Map.Entry::getKey).collect(Collectors.toList());
        OutputMode outputMode = OutputModes.detectOutputMode(stmts);
        SPARQLResultExProcessor resultProcessor = SPARQLResultExProcessorBuilder.configureProcessor(StdIo.openStdOutWithCloseShield(), System.err, outFormat, stmts, pm, RDFFormat.TURTLE_BLOCKS, RDFFormat.TRIG_BLOCKS, deferCount, false, 0, false, () -> {});
        Function<RDFConnection, SPARQLResultEx> mapper = SparqlMappers.createMapperToSparqlResultEx(outputMode, stmts, resultProcessor);
        Flowable flow = NamedGraphStreamCliUtils.createNamedGraphStreamFromArgs(sourceStrs, null, pm, quadLangs).compose(RxOps.createParallelMapperOrdered(SparqlMappers.mapDatasetToConnection(SparqlMappers.applyContextHandler(contextMutator).andThen(mapper))));
        resultProcessor.start();
        try {
            RxUtils.consume((Flowable)flow.map(item -> {
                resultProcessor.forwardEx((SPARQLResultEx)item);
                return item;
            }));
            resultProcessor.finish();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            resultProcessor.flush();
            resultProcessor.close();
        }
    }
}

