/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx.io.resultset;

import com.google.gson.JsonElement;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Objects;
import org.aksw.jena_sparql_api.rx.io.resultset.SinkStreamingBase;
import org.apache.jena.atlas.io.IO;

public class SinkStreamingJsonArray
extends SinkStreamingBase<JsonElement> {
    protected OutputStream out;
    protected PrintStream pout;
    protected boolean writeArray = true;
    protected boolean isFirstItem = true;

    public SinkStreamingJsonArray(OutputStream out) {
        this(out, true);
    }

    public SinkStreamingJsonArray(OutputStream out, boolean writeArray) {
        this.writeArray = writeArray;
        this.out = out;
        this.pout = new PrintStream(out);
    }

    public void flush() {
        IO.flush((OutputStream)this.out);
    }

    @Override
    public void close() {
        IO.flush((OutputStream)this.out);
    }

    @Override
    protected void startActual() {
        if (this.writeArray) {
            this.pout.print("[");
        }
    }

    @Override
    protected void sendActual(JsonElement item) {
        if (this.isFirstItem) {
            this.isFirstItem = false;
        } else if (this.writeArray) {
            this.pout.println(",");
        }
        this.pout.print(Objects.toString(item));
    }

    @Override
    protected void finishActual() {
        if (this.writeArray) {
            this.pout.println("]");
        }
    }
}

