/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.rx.op;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.aksw.jenax.arq.util.binding.CollectionFromTable;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.sparql.query.rx.SparqlRx;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionFactory;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.TransformUnionQuery;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;

public class ResultSetMappers {
    public static <T> Function<Dataset, T> wrapForDataset(Function<? super SparqlQueryConnection, T> fn) {
        return dataset -> {
            Object result;
            try (RDFConnection conn = RDFConnectionFactory.connect((Dataset)dataset);){
                result = fn.apply((SparqlQueryConnection)conn);
            }
            return result;
        };
    }

    public static Function<? super SparqlQueryConnection, Table> createTableMapper(Query rawKeyQuery) {
        Query keyQuery = QueryUtils.applyOpTransform((Query)rawKeyQuery, TransformUnionQuery::transform);
        List projectVars = keyQuery.getProjectVars();
        Function<SparqlQueryConnection, Table> result = conn -> {
            Function<List<Binding>, Table> buffer = SparqlRx.createTableBuffer(projectVars);
            Table table = (Table)SparqlRx.execSelectRaw(() -> conn.query(keyQuery)).toList().map(buffer::apply).blockingGet();
            return table;
        };
        return result;
    }

    public static Function<? super SparqlQueryConnection, Collection<Node>> createMultiNodeMapper(Query rawKeyQuery) {
        List projectVars = rawKeyQuery.getProjectVars();
        if (projectVars.size() != 1) {
            throw new RuntimeException("Key query must have exactly 1 result var");
        }
        Var projectVar = (Var)projectVars.get(0);
        Function<Binding, Node> mapper = ResultSetMappers.createNodeMapper(projectVar);
        return ResultSetMappers.createTableMapper(rawKeyQuery).andThen(table -> new CollectionFromTable(table, null, mapper::apply));
    }

    public static Function<? super SparqlQueryConnection, Node> createNodeMapper(Query rawKeyQuery, Node defaultValue) {
        return ResultSetMappers.createMultiNodeMapper(rawKeyQuery).andThen(nodes -> (Node)Iterables.getFirst((Iterable)nodes, (Object)defaultValue));
    }

    public static Function<? super SparqlQueryConnection, Collection<List<Node>>> createTupleMapper(Query rawKeyQuery) {
        List projectVars = rawKeyQuery.getProjectVars();
        Function<Binding, List<Node>> mapper = ResultSetMappers.createTupleMapper(projectVars);
        return ResultSetMappers.createTableMapper(rawKeyQuery).andThen(table -> new CollectionFromTable(table, null, mapper::apply));
    }

    public static Function<Binding, List<Node>> createTupleMapper(List<Var> vars) {
        int n = vars.size();
        return binding -> {
            ArrayList<Node> r = new ArrayList<Node>(n);
            for (Var v : vars) {
                Node node = binding.get(v);
                r.add(node);
            }
            return r;
        };
    }

    public static Function<Binding, Node> createNodeMapper(Var var) {
        return binding -> {
            Node r = binding.get(var);
            return r;
        };
    }
}

