/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.rx.op;

import com.google.common.base.Strings;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableOperator;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.commons.rx.op.FlowableOperatorCollapseRuns;
import org.aksw.commons.util.stream.CollapseRunsSpec;
import org.aksw.jenax.arq.dataset.api.RDFNodeInDataset;
import org.aksw.jenax.arq.dataset.api.ResourceInDataset;
import org.aksw.jenax.arq.dataset.impl.ResourceInDatasetImpl;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.sparql.relation.dataset.GraphNameAndNode;
import org.aksw.jenax.sparql.relation.dataset.NodesInDataset;
import org.aksw.jenax.sparql.relation.dataset.NodesInDatasetImpl;
import org.aksw.jenax.sparql.rx.op.ConsecutiveGraphMergerMergerForResourceInDataset;
import org.aksw.jenax.sparql.rx.op.ResultSetMappers;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionFactory;
import org.apache.jena.rdfconnection.SparqlQueryConnection;

public class FlowOfRdfNodesInDatasetsOps {
    public static Flowable<ResourceInDataset> naturalResources(Dataset dataset) {
        return Flowable.fromIterable(() -> dataset.listNames()).map(graphName -> {
            Node node = NodeFactory.createURI((String)graphName);
            return new ResourceInDatasetImpl(dataset, graphName, node);
        });
    }

    public static Function<Dataset, NodesInDataset> mapToNodesInDataset(Query nodeSelector) {
        Function<? super SparqlQueryConnection, Collection<List<Node>>> mapper = ResultSetMappers.createTupleMapper(nodeSelector);
        return dataset -> {
            try (RDFConnection conn = RDFConnectionFactory.connect((Dataset)dataset);){
                NodesInDatasetImpl r;
                Collection tuples = (Collection)mapper.apply((SparqlQueryConnection)conn);
                Set gan = tuples.stream().map(tuple -> {
                    Node g = (Node)tuple.get(0);
                    Node node = (Node)tuple.get(1);
                    String graphName = g.getURI();
                    return new GraphNameAndNode(graphName, node);
                }).collect(Collectors.toSet());
                NodesInDatasetImpl nodesInDatasetImpl = r = new NodesInDatasetImpl(dataset, gan);
                return nodesInDatasetImpl;
            }
        };
    }

    public static FlowableTransformer<ResourceInDataset, NodesInDataset> groupedResourceInDataset() {
        return upstream -> upstream.lift((FlowableOperator)FlowableOperatorCollapseRuns.create((CollapseRunsSpec)CollapseRunsSpec.create(RDFNodeInDataset::getDataset, (k1, k2) -> k1 == k2 || k1.asDatasetGraph() == k2.asDatasetGraph(), key -> new ArrayList(), (list, item) -> {
            list.add(item);
            return list;
        }))).map(Map.Entry::getValue).map(list -> {
            ResourceInDataset proto = (ResourceInDataset)list.get(0);
            Dataset ds = proto.getDataset();
            Set nodes = list.stream().map(r -> new GraphNameAndNode(r.getGraphName(), r.asNode())).collect(Collectors.toSet());
            return new NodesInDatasetImpl(ds, nodes);
        });
    }

    public static List<ResourceInDataset> ungroupResourceInDataset(NodesInDataset grid) {
        List<ResourceInDataset> result = grid.getGraphNameAndNodes().stream().map(gan -> new ResourceInDatasetImpl(grid.getDataset(), gan.getGraphName(), gan.getNode())).collect(Collectors.toList());
        return result;
    }

    public static Flowable<ResourceInDataset> ungrouperResourceInDataset(NodesInDataset grid) {
        return Flowable.fromIterable(FlowOfRdfNodesInDatasetsOps.ungroupResourceInDataset(grid));
    }

    public static Function<? super SparqlQueryConnection, Node> createKeyMapper(String keyArg, Function<? super String, ? extends Query> queryParser, Query fallback) {
        Query effectiveKeyQuery;
        boolean useFallback = Strings.isNullOrEmpty((String)keyArg);
        if (!useFallback) {
            effectiveKeyQuery = queryParser.apply(keyArg);
            QueryUtils.optimizePrefixes((Query)effectiveKeyQuery);
        } else {
            effectiveKeyQuery = fallback;
        }
        Function<? super SparqlQueryConnection, Node> result = ResultSetMappers.createNodeMapper(effectiveKeyQuery, NodeFactory.createLiteral((String)""));
        return result;
    }

    public static Flowable<NodesInDataset> mergeConsecutiveResourceInDatasets(Flowable<NodesInDataset> in) {
        ConsecutiveGraphMergerMergerForResourceInDataset merger = new ConsecutiveGraphMergerMergerForResourceInDataset();
        return in.flatMapMaybe(x -> Maybe.fromCallable(() -> merger.accept((NodesInDataset)x).orElse(null))).concatWith((MaybeSource)Maybe.fromCallable(() -> merger.getPendingDataset().orElse(null)));
    }

    public static FlowableTransformer<ResourceInDataset, ResourceInDataset> createTransformerFromGroupedTransform(FlowableTransformer<NodesInDataset, NodesInDataset> innerTransform) {
        return upstream -> upstream.compose(FlowOfRdfNodesInDatasetsOps.groupedResourceInDataset()).compose(innerTransform).flatMap(FlowOfRdfNodesInDatasetsOps::ungrouperResourceInDataset);
    }
}

