/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.rx.op;

import io.reactivex.rxjava3.core.Flowable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Supplier;
import org.aksw.commons.lambda.serializable.SerializableConsumer;
import org.aksw.commons.lambda.serializable.SerializableSupplier;
import org.aksw.commons.rx.function.RxFunction;
import org.aksw.jena_sparql_api.rx.io.resultset.SPARQLResultExProcessor;
import org.aksw.jena_sparql_api.rx.io.resultset.SPARQLResultExProcessorBuilder;
import org.aksw.jena_sparql_api.rx.io.resultset.SparqlMappers;
import org.aksw.jenax.arq.dataset.api.DatasetOneNg;
import org.aksw.jenax.arq.dataset.impl.DatasetOneNgImpl;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.core.SparqlStmtQuery;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.Context;

public class FlowOfDatasetOps {
    public static RxFunction<Dataset, Dataset> mapWithSparql(Query query) {
        return FlowOfDatasetOps.mapWithSparql(Collections.singleton(new SparqlStmtQuery(query)));
    }

    public static RxFunction<Dataset, Dataset> mapWithSparql(Collection<? extends SparqlStmt> stmts) {
        return FlowOfDatasetOps.mapWithSparql(stmts, (SerializableSupplier<? extends DatasetGraph>)((SerializableSupplier & Serializable)DatasetGraphFactory::create), (SerializableConsumer<Context>)(SerializableConsumer & Serializable)cxt -> {});
    }

    public static Flowable<Quad> flatMapToQuads(Flowable<Dataset> in) {
        return in.flatMap(ds -> Flowable.fromIterable(() -> ds.asDatasetGraph().find()));
    }

    public static RxFunction<Dataset, Dataset> mapWithSparql(Collection<? extends SparqlStmt> sparqlStmts, SerializableSupplier<? extends DatasetGraph> datasetGraphSupplier, SerializableConsumer<Context> contextMutator) {
        RxFunction & Serializable mapper = (RxFunction & Serializable)upstream -> {
            SPARQLResultExProcessor resultProcessor = SPARQLResultExProcessorBuilder.createForQuadOutput().build();
            Function<RDFConnection, Iterable<Dataset>> connectionBasedMapper = SparqlMappers.createMapperDataset(sparqlStmts, resultProcessor, (Supplier<? extends DatasetGraph>)datasetGraphSupplier);
            Function datasetBasedMapper = SparqlMappers.mapDatasetToConnection(connectionBasedMapper);
            return upstream.flatMap(dataset -> {
                Iterable datasets = (Iterable)datasetBasedMapper.apply(dataset);
                return Flowable.fromIterable((Iterable)datasets);
            });
        };
        return mapper;
    }

    public static Flowable<DatasetOneNg> namedGraphs(Dataset dataset) {
        return Flowable.just((Object)dataset).compose(FlowOfDatasetOps.flatMapNamedGraphs());
    }

    public static RxFunction<Dataset, DatasetOneNg> flatMapNamedGraphs() {
        return (RxFunction & Serializable)upstream -> upstream.flatMap(ds -> ds instanceof DatasetOneNg ? Flowable.just((Object)((DatasetOneNg)ds)) : Flowable.fromIterable(() -> ds.listNames()).map(iri -> DatasetOneNgImpl.create((String)iri, (Graph)ds.getNamedModel(iri).getGraph())));
    }
}

