/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.query.rx;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableEmitter;
import io.reactivex.rxjava3.core.FlowableOperator;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.processors.PublishProcessor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.aksw.commons.collections.SetUtils;
import org.aksw.commons.rx.op.FlowableOperatorCollapseRuns;
import org.aksw.commons.rx.util.FlowableUtils;
import org.aksw.commons.util.stream.CollapseRunsSpec;
import org.aksw.jenax.arq.aggregation.AccGraph2;
import org.aksw.jenax.arq.util.binding.BindingUtils;
import org.aksw.jenax.arq.util.exception.HttpExceptionUtils;
import org.aksw.jenax.arq.util.quad.QuadPatternUtils;
import org.aksw.jenax.arq.util.syntax.QueryGenerationUtils;
import org.aksw.jenax.arq.util.var.VarUtils;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecFactories;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecFactoryQuery;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQuery;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.SortCondition;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.table.TableData;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIteratorResultSet;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.http.QueryExecHTTP;
import org.apache.jena.sparql.exec.http.QueryExecHTTPBuilder;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTP;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.modify.TemplateLib;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.PatternVars;
import org.apache.jena.sparql.syntax.Template;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlRx {
    private static final Logger logger = LoggerFactory.getLogger(SparqlRx.class);

    public static Single<Boolean> execAsk(Function<Query, QueryExecution> qeSupp, Query query) {
        return Flowable.generate(() -> (QueryExecution)qeSupp.apply(query), (qe, e) -> {
            try {
                boolean r = qe.execAsk();
                e.onNext((Object)r);
                e.onComplete();
            }
            catch (Exception ex) {
                e.onError((Throwable)ex);
            }
        }, QueryExecution::close).singleOrError().onErrorResumeNext(Single::error);
    }

    public static Flowable<Binding> execSelectRaw(Callable<? extends SparqlQueryConnection> queryConnSupp, Query query) {
        return SparqlRx.execSelectRaw(() -> ((SparqlQueryConnection)queryConnSupp.call()).query(query));
    }

    public static Flowable<Binding> execSelectRaw(QueryExecutionFactoryQuery qeSupp, Query query) {
        return SparqlRx.execSelectRaw(() -> qeSupp.createQueryExecution(query));
    }

    public static Flowable<Binding> execSelectRaw(SparqlQueryConnection queryConn, Query query) {
        return SparqlRx.execSelectRaw(() -> queryConn.query(query));
    }

    public static <K, X> Flowable<Map.Entry<K, List<X>>> groupByOrdered(Flowable<X> in, Function<X, K> getGroupKey) {
        Object[] current = new Object[]{null};
        Object[] prior = new Object[]{null};
        PublishProcessor boundaryIndicator = PublishProcessor.create();
        return in.doOnComplete(() -> ((PublishProcessor)boundaryIndicator).onComplete()).doOnNext(item -> {
            Object groupKey = getGroupKey.apply(item);
            boolean isEqual = Objects.equals(current, groupKey);
            prior[0] = current[0];
            if (prior[0] == null) {
                prior[0] = groupKey;
            }
            current[0] = groupKey;
            if (!isEqual) {
                boundaryIndicator.onNext(groupKey);
            }
        }).buffer((Publisher)boundaryIndicator).map(buffer -> {
            Object tmp;
            Object groupKey = tmp = prior[0];
            return Maps.immutableEntry((Object)groupKey, (Object)buffer);
        });
    }

    public static Function<List<Binding>, Table> createTableBuffer(List<Var> vars) {
        Function<List<Binding>, Table> result = rows -> new TableData(vars, rows);
        return result;
    }

    public static <T> void processExecSelect(FlowableEmitter<T> emitter, QueryExecution qex, Function<? super ResultSet, ? extends T> next) {
        Query q = qex.getQuery();
        try (QueryExecution qe = qex;){
            emitter.setCancellable(() -> ((QueryExecution)qe).abort());
            ResultSet rs = qe.execSelect();
            while (!emitter.isCancelled() && rs.hasNext()) {
                T binding = next.apply((ResultSet)rs);
                emitter.onNext(binding);
            }
            emitter.onComplete();
        }
        catch (Exception e) {
            RuntimeException f = HttpExceptionUtils.makeHumanFriendly((Exception)e);
            emitter.onError(new Throwable("Error executing " + String.valueOf(q), f));
        }
    }

    public static void processExecConstructTriples(FlowableEmitter<Triple> emitter, QueryExecution qex) {
        try (QueryExecution qe = qex;){
            emitter.setCancellable(() -> ((QueryExecution)qe).abort());
            Iterator it = qe.execConstructTriples();
            while (!emitter.isCancelled() && it.hasNext()) {
                Triple item = (Triple)it.next();
                emitter.onNext((Object)item);
            }
            emitter.onComplete();
        }
        catch (Exception e) {
            emitter.onError((Throwable)e);
        }
    }

    public static <T> Flowable<T> execSelect(Callable<? extends QueryExecution> qes, Function<? super ResultSet, T> next) {
        Flowable result = FlowableUtils.createFlowableFromResource(qes::call, QueryExecution::execSelect, ResultSet::hasNext, next, QueryExecution::close);
        return result;
    }

    public static Flowable<Binding> execSelectRaw(Callable<? extends QueryExecution> qes) {
        return SparqlRx.execSelect(qes, ResultSet::nextBinding);
    }

    public static Flowable<QuerySolution> execSelect(Callable<? extends QueryExecution> qes) {
        return SparqlRx.execSelect(qes, ResultSet::next);
    }

    public static Flowable<QuerySolution> execSelect(SparqlQueryConnection conn, String queryStr) {
        return SparqlRx.execSelect(() -> conn.query(queryStr), ResultSet::next);
    }

    public static Flowable<QuerySolution> execSelect(SparqlQueryConnection conn, Query query) {
        return SparqlRx.execSelect(() -> conn.query(query), ResultSet::next);
    }

    public static Flowable<Triple> execConstructTriples(SparqlQueryConnection conn, Query query) {
        return SparqlRx.execConstructTriples(() -> conn.query(query));
    }

    public static Flowable<Triple> execConstructTriples(Callable<QueryExecution> qes) {
        Flowable result = FlowableUtils.createFlowableFromResource(qes::call, QueryExecution::execConstructTriples, Iterator::hasNext, Iterator::next, QueryExecution::close);
        return result;
    }

    public static Flowable<Triple> constructTriples(Callable<QueryExec> qes) {
        Flowable result = FlowableUtils.createFlowableFromResource(qes::call, QueryExec::constructTriples, Iterator::hasNext, Iterator::next, QueryExec::close);
        return result;
    }

    public static Flowable<Quad> execConstructQuads(SparqlQueryConnection conn, Query query) {
        return SparqlRx.execConstructQuads(() -> conn.query(query));
    }

    public static Flowable<Quad> execConstructQuads(Callable<QueryExecution> qes) {
        Flowable result = FlowableUtils.createFlowableFromResource(qes::call, QueryExecution::execConstructQuads, Iterator::hasNext, Iterator::next, QueryExecution::close);
        return result;
    }

    public static Flowable<JsonObject> execJsonItems(SparqlQueryConnection conn, Query query) {
        return SparqlRx.execJsonItems(() -> conn.query(query));
    }

    public static Flowable<JsonObject> execJsonItems(Callable<QueryExecution> qes) {
        Flowable result = FlowableUtils.createFlowableFromResource(qes::call, QueryExecution::execJsonItems, Iterator::hasNext, Iterator::next, QueryExecution::close);
        return result;
    }

    public static <T> Flowable<T> select(Callable<? extends QueryExec> qes, Function<? super RowSet, T> next) {
        Flowable result = FlowableUtils.createFlowableFromResource(qes::call, QueryExec::select, RowSet::hasNext, next, QueryExec::close);
        return result;
    }

    public static Flowable<Binding> select(QueryExecFactoryQuery qef, Query query) {
        return SparqlRx.select(() -> qef.create(query));
    }

    public static Flowable<Binding> select(Callable<? extends QueryExec> qes) {
        return SparqlRx.select(qes, RowSet::next);
    }

    public static Map.Entry<List<Var>, Flowable<Binding>> mapToFlowable(ResultSet rs) {
        QueryIteratorResultSet it = new QueryIteratorResultSet(rs);
        Iterable i = () -> SparqlRx.lambda$mapToFlowable$14((Iterator)it);
        List vars = VarUtils.toList((Collection)rs.getResultVars());
        Flowable flowable = Flowable.fromIterable(i);
        AbstractMap.SimpleEntry<List<Var>, Flowable<Binding>> result = new AbstractMap.SimpleEntry<List<Var>, Flowable<Binding>>(vars, flowable);
        return result;
    }

    public static Flowable<Binding> mapToBinding(ResultSet rs) {
        Map.Entry<List<Var>, Flowable<Binding>> e = SparqlRx.mapToFlowable(rs);
        Flowable<Binding> result = e.getValue();
        return result;
    }

    public static Function<Binding, Binding> createGrouper(Collection<Var> vars, boolean retainNulls) {
        return b -> {
            BindingBuilder groupKey = BindingFactory.builder();
            for (Var k : vars) {
                Node v = b.get(k);
                if (v == null && !retainNulls) continue;
                groupKey.add(k, v);
            }
            return groupKey.build();
        };
    }

    public static Function<Binding, Node> createGrouper(Var var) {
        return b -> {
            Node groupKey = b.get(var);
            return groupKey;
        };
    }

    public static void main2(String[] args) {
        Integer[] currentValue = new Integer[]{null};
        boolean[] isCancelled = new boolean[]{false};
        Flowable list = Flowable.range((int)0, (int)10).doOnNext(i -> {
            currentValue[0] = i;
        }).doOnCancel(() -> {
            isCancelled[0] = true;
        }).map(i -> Maps.immutableEntry((Object)(i / 3), (Object)i)).lift((FlowableOperator)FlowableOperatorCollapseRuns.create((CollapseRunsSpec)CollapseRunsSpec.create(Map.Entry::getKey, groupKey -> new ArrayList(), (acc, e) -> acc.add((Integer)e.getValue()))));
        Predicate p = e -> ((Integer)e.getKey()).equals(1);
        list.takeUntil(p).subscribe(x -> System.out.println("Item: " + String.valueOf(x)));
        System.out.println("Value = " + currentValue[0] + ", isCancelled = " + isCancelled[0]);
        PublishProcessor queue = PublishProcessor.create();
        queue.buffer(3).subscribe(x -> System.out.println("Buffer: " + String.valueOf(x)));
        for (int i2 = 0; i2 < 10; ++i2) {
            String item = "item" + i2;
            System.out.println("Adding " + item);
            queue.onNext((Object)item);
        }
        queue.onComplete();
    }

    public static Single<Number> fetchNumber(QueryExecFactoryQuery qef, Query query, Var var) {
        Callable<QueryExec> callable = () -> qef.create(query);
        Single<Number> result = SparqlRx.fetchNumber(callable, var);
        return result;
    }

    public static Single<Number> fetchNumber(Callable<? extends QueryExec> queryConnSupp, Var var) {
        Single result = SparqlRx.select(queryConnSupp).map(b -> BindingUtils.getNumber((Binding)b, (Node)var)).singleOrError().onErrorResumeNext(Single::error);
        return result;
    }

    public static Single<Range<Long>> fetchCountQueryPartition(QueryExecutionFactoryQuery qef, Query query, Collection<Var> partitionVars, Long itemLimit, Long rowLimit) {
        return SparqlRx.fetchCountQueryPartition(QueryExecFactories.adapt((QueryExecutionFactoryQuery)qef), query, partitionVars, itemLimit, rowLimit);
    }

    public static Single<Range<Long>> fetchCountQueryPartition(QueryExecFactoryQuery qef, Query query, Collection<Var> partitionVars, Long itemLimit, Long rowLimit) {
        Long xitemLimit = itemLimit == null ? null : Long.valueOf(itemLimit + 1L);
        Long xrowLimit = rowLimit == null ? null : Long.valueOf(rowLimit + 1L);
        Map.Entry countQuery = QueryGenerationUtils.createQueryCountPartition((Query)query, partitionVars, (Long)xitemLimit, (Long)xrowLimit);
        Var v = (Var)countQuery.getKey();
        Query q = (Query)countQuery.getValue();
        return SparqlRx.fetchNumber(qef, q, v).map(count -> SparqlRx.toRange(count.longValue(), xitemLimit, xrowLimit));
    }

    public static Single<Long> fetchBindingCount(String serviceUrl, Query query) {
        Map.Entry countQuery = QueryGenerationUtils.createQueryCount((Query)query);
        return SparqlRx.fetchNumber(() -> (QueryExec)((QueryExecHTTPBuilder)((QueryExecHTTPBuilder)QueryExecHTTP.newBuilder().endpoint(serviceUrl)).query((Query)countQuery.getValue())).build(), (Var)countQuery.getKey()).map(Number::longValue);
    }

    public static Single<Range<Long>> fetchCountQuery(QueryExecutionFactoryQuery qef, Query query, Long itemLimit, Long rowLimit) {
        Single<Range<Long>> result = SparqlRx.fetchCountQueryPartition(QueryExecFactories.adapt((QueryExecutionFactoryQuery)qef), query, null, itemLimit, rowLimit);
        return result;
    }

    public static Single<Range<Long>> fetchCountQuery(QueryExecFactoryQuery qef, Query query, Long itemLimit, Long rowLimit) {
        Single<Range<Long>> result = SparqlRx.fetchCountQueryPartition(qef, query, null, itemLimit, rowLimit);
        return result;
    }

    public static Range<Long> toRange(Long count, Long itemLimit, Long rowLimit) {
        boolean mayHaveMoreItems = rowLimit != null ? true : itemLimit != null && count > itemLimit;
        Range r = mayHaveMoreItems ? Range.atLeast((Comparable)count) : Range.singleton((Comparable)count);
        return r;
    }

    public static Flowable<RDFNode> execConstructGrouped(QueryExecutionFactoryQuery conn, Map.Entry<? extends Node, Query> e) {
        return SparqlRx.execConstructGrouped(conn, e, true);
    }

    public static Flowable<RDFNode> execConstructGrouped(QueryExecutionFactoryQuery conn, Map.Entry<? extends Node, Query> e, boolean sortRowsByPartitionVar) {
        Node s = e.getKey();
        Query q = e.getValue();
        return SparqlRx.execConstructGrouped(conn, q, s, sortRowsByPartitionVar);
    }

    @Deprecated
    public static Flowable<RDFNode> execPartitioned(QueryExecutionFactoryQuery conn, Map.Entry<? extends Node, Query> e) {
        return SparqlRx.execPartitioned(conn, e, true);
    }

    @Deprecated
    public static Flowable<RDFNode> execPartitioned(QueryExecutionFactoryQuery conn, Map.Entry<? extends Node, Query> e, boolean sortRowsByPartitionVar) {
        Node s = e.getKey();
        Query q = e.getValue();
        return SparqlRx.execPartitioned(conn, s, q, sortRowsByPartitionVar);
    }

    public static Flowable<RDFNode> execConstructGrouped(QueryExecutionFactoryQuery conn, Query query, Node s) {
        return SparqlRx.execConstructGrouped(conn, query, s, true);
    }

    public static Flowable<RDFNode> execConstructGrouped(QueryExecutionFactoryQuery conn, Query query, Node s, boolean sortRowsByPartitionVar) {
        return SparqlRx.execConstructGrouped(arg_0 -> ((QueryExecutionFactoryQuery)conn).createQueryExecution(arg_0), query, Collections.singletonList((Var)s), s, sortRowsByPartitionVar).map(Map.Entry::getValue);
    }

    public static Flowable<Map.Entry<Binding, RDFNode>> execConstructGrouped(RDFDataSource dataSource, Query query, List<Var> primaryKeyVars, Node rootNode, boolean sortRowsByPartitionVar) {
        return SparqlRx.execConstructGrouped((Query q) -> dataSource.asQef().createQueryExecution(q), query, primaryKeyVars, rootNode, sortRowsByPartitionVar);
    }

    public static Flowable<Map.Entry<Binding, RDFNode>> execConstructGrouped(Function<Query, QueryExecution> qeSupp, Query query, List<Var> primaryKeyVars, Node rootNode, boolean sortRowsByPartitionVar) {
        if (rootNode.isVariable() && !primaryKeyVars.contains(rootNode)) {
            throw new RuntimeException("If the root node is a variable it must be among the primary key ones");
        }
        Template template = query.getConstructTemplate();
        Query clone = SparqlRx.preprocessQueryForPartition(query, primaryKeyVars, sortRowsByPartitionVar);
        Function<Binding, Binding> grouper = SparqlRx.createGrouper(primaryKeyVars, false);
        Flowable result = SparqlRx.execSelectRaw(() -> (QueryExecution)qeSupp.apply(clone)).lift((FlowableOperator)FlowableOperatorCollapseRuns.create((CollapseRunsSpec)CollapseRunsSpec.create(grouper::apply, groupKey -> new AccGraph2(template), AccGraph2::accumulate))).map(keyAndAcc -> {
            Binding groupKey = (Binding)keyAndAcc.getKey();
            AccGraph2 accGraph = (AccGraph2)keyAndAcc.getValue();
            Map bnodeMap = accGraph.getBnodeMap();
            Node effectiveRoot = rootNode.isVariable() ? groupKey.get((Var)rootNode) : (rootNode.isBlank() ? (Node)bnodeMap.get(rootNode) : rootNode);
            Graph g = accGraph.getValue();
            Model m = ModelFactory.createModelForGraph((Graph)g);
            RDFNode r = m.asRDFNode(effectiveRoot);
            return Maps.immutableEntry((Object)groupKey, (Object)r);
        });
        return result;
    }

    public static Query preprocessQueryForPartition(Query q, List<Var> primaryKeyVars, boolean sortRowsByPartitionVar) {
        Template template = q.getConstructTemplate();
        LinkedHashSet<Var> projectVars = new LinkedHashSet<Var>();
        projectVars.addAll(primaryKeyVars);
        projectVars.addAll(QuadPatternUtils.getVarsMentioned((Iterable)template.getQuads()));
        Query clone = q.cloneQuery();
        clone.setQuerySelectType();
        clone.getProject().clear();
        if (projectVars.isEmpty()) {
            Set patternVars = SetUtils.asSet((Iterable)PatternVars.vars((Element)q.getQueryPattern()));
            if (patternVars.isEmpty()) {
                clone.setQueryResultStar(true);
            } else {
                Var v = (Var)patternVars.iterator().next();
                clone.setQueryResultStar(false);
                clone.getProject().add(v);
            }
        } else {
            clone.setQueryResultStar(false);
            clone.addProjectVars(projectVars);
        }
        clone.setDistinct(true);
        if (sortRowsByPartitionVar) {
            for (Var primaryKeyVar : primaryKeyVars) {
                clone.addOrderBy(new SortCondition(primaryKeyVar, 1));
            }
        }
        logger.debug("Converted query to: " + String.valueOf(clone));
        return clone;
    }

    @Deprecated
    public static Flowable<RDFNode> execPartitioned(QueryExecutionFactoryQuery conn, Node s, Query q, boolean sortRowsByPartitionVar) {
        Template template = q.getConstructTemplate();
        Query clone = SparqlRx.preprocessQueryForPartition(q, Collections.singletonList((Var)s), sortRowsByPartitionVar);
        Flowable result = SparqlRx.execSelectRaw(() -> conn.createQueryExecution(clone)).map(b -> {
            Graph graph = GraphFactory.createDefaultGraph();
            if (template != null) {
                Iterator it = TemplateLib.calcTriples((List)template.getTriples(), (Iterator)Iterators.singletonIterator((Object)b));
                while (it.hasNext()) {
                    Triple t = (Triple)it.next();
                    graph.add(t);
                }
            }
            Node rootNode = s.isVariable() ? b.get((Var)s) : s;
            Model m = ModelFactory.createModelForGraph((Graph)graph);
            RDFNode r = m.asRDFNode(rootNode);
            return r;
        });
        return result;
    }

    public static <T extends RDFNode> Flowable<T> execConcept(Callable<QueryExecution> qeSupp, Var var, Class<T> clazz) {
        return SparqlRx.execConcept(qeSupp, var).map(rdfNode -> rdfNode.as(clazz));
    }

    public static Flowable<RDFNode> execConcept(Callable<QueryExecution> qeSupp, Var var) {
        String varName = var.getName();
        return SparqlRx.execSelect(qeSupp).map(qs -> qs.get(varName));
    }

    public static Flowable<Node> execConceptRaw(Callable<QueryExecution> qeSupp, Var var) {
        return SparqlRx.execSelectRaw(qeSupp).map(binding -> binding.get(var));
    }

    public static Flowable<Node> execConceptRaw(SparqlQueryConnection conn, Query query, Var var) {
        return SparqlRx.execConceptRaw(() -> conn.query(query), var);
    }

    public static <T extends RDFNode> Flowable<T> execConcept(Function<? super Query, ? extends QueryExecution> qef, Query query, Var var, Class<T> clazz) {
        return SparqlRx.execConcept(() -> (QueryExecution)qef.apply(query), var).map(rdfNode -> rdfNode.as(clazz));
    }

    public static Flowable<Node> execConceptRaw(Function<? super Query, ? extends QueryExecution> qef, Query query, Var var) {
        return SparqlRx.execConceptRaw(() -> (QueryExecution)qef.apply(query), var);
    }

    public static Flowable<Node> execConceptRaw(Function<? super Query, ? extends QueryExecution> qef, Query query) {
        Var var = (Var)Iterables.getOnlyElement((Iterable)query.getProjectVars());
        return SparqlRx.execConceptRaw(qef, query, var);
    }

    private static /* synthetic */ void lambda$main2$27(int[] i, Binding x) throws Throwable {
        i[0] = i[0] + 1;
        System.out.println("x: " + String.valueOf(x));
    }

    private static /* synthetic */ boolean lambda$main2$26(int[] i, Binding b) throws Throwable {
        return i[0] == 10;
    }

    private static /* synthetic */ QueryExecution lambda$main2$25() throws Exception {
        return QueryExecutionHTTP.service((String)"http://dbpedia.org/sparql", (String)"SELECT * { ?s a <http://dbpedia.org/ontology/Person> }");
    }

    private static /* synthetic */ Iterator lambda$mapToFlowable$14(Iterator it) {
        return it;
    }
}

