/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.query.rx;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.core.Maybe;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.aksw.commons.lambda.serializable.SerializableFunction;
import org.aksw.commons.lambda.serializable.SerializableSupplier;
import org.aksw.commons.lambda.throwing.ThrowingSupplier;
import org.aksw.commons.rx.util.FlowableEx;
import org.aksw.commons.rx.util.FlowableUtils;
import org.aksw.jena_sparql_api.rx.AllocScopePolicy;
import org.aksw.jenax.arq.dataset.orderaware.DatasetGraphFactoryEx;
import org.aksw.jenax.arq.util.irixresolver.IRIxResolverUtils;
import org.aksw.jenax.arq.util.node.BlankNodeAllocatorAsGivenOrRandom;
import org.aksw.jenax.arq.util.quad.DatasetUtils;
import org.aksw.jenax.arq.util.quad.QuadPatternUtils;
import org.aksw.jenax.arq.util.streamrdf.StreamRDFWriterEx;
import org.aksw.jenax.sparql.query.rx.Alloc;
import org.aksw.jenax.sparql.query.rx.RDFDataMgrEx;
import org.aksw.jenax.sparql.query.rx.StreamUtils;
import org.aksw.jenax.sparql.rx.op.FlowOfQuadsOps;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RDFParserBuilder;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.ResultSetMgr;
import org.apache.jena.riot.lang.BlankNodeAllocator;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.system.AsyncParser;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.FactoryRDF;
import org.apache.jena.riot.system.MapWithScope;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.ParserProfileStd;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.util.Context;

public class RDFDataMgrRx {
    public static Flowable<Triple> createFlowableTriples(String filenameOrURI, Lang lang, String baseIRI) {
        return RDFDataMgrRx.createFlowableTriples(() -> RDFDataMgr.open((String)filenameOrURI), lang, baseIRI);
    }

    public static Flowable<Binding> createFlowableBindings(String filenameOrURI, Lang lang) {
        return RDFDataMgrRx.createFlowableBindings(() -> RDFDataMgr.open((String)filenameOrURI), lang);
    }

    public static Flowable<Binding> createFlowableBindings(Callable<InputStream> inSupp, Lang lang) {
        return RDFDataMgrRx.createFlowableBindings(() -> {
            ContentType ct = lang.getContentType();
            InputStream in = (InputStream)inSupp.call();
            return new TypedInputStream(in, ct);
        });
    }

    public static Flowable<Binding> createFlowableBindings(Callable<TypedInputStream> inSupp) {
        Flowable result = FlowableUtils.createFlowableFromResource(inSupp, in -> {
            Lang lang = RDFLanguages.contentTypeToLang((String)in.getContentType());
            ResultSet rs = ResultSetMgr.read((InputStream)in.getInputStream(), (Lang)lang);
            return rs;
        }, ResultSet::hasNext, ResultSet::nextBinding, in -> {
            try {
                in.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return result;
    }

    public static Flowable<Triple> createFlowableTriples(Callable<InputStream> inSupplier, Lang lang, String baseIRI) {
        return FlowableEx.fromIteratorSupplier((ThrowingSupplier & Serializable)() -> AsyncParser.of((InputStream)((InputStream)inSupplier.call()), (Lang)lang, (String)baseIRI).mutateSources(source -> RDFDataMgrRx.applyParserDefaults(source)).asyncParseTriples(), Closeable::close);
    }

    public static Flowable<Resource> createFlowableResources(String filenameOrURI, Lang lang, String baseIRI) {
        return RDFDataMgrRx.createFlowableResources(() -> RDFDataMgr.open((String)filenameOrURI), lang, baseIRI);
    }

    public static Flowable<Dataset> createFlowableDatasets(String filenameOrURI, Lang lang, String baseIRI) {
        return RDFDataMgrRx.createFlowableDatasets(() -> RDFDataMgr.open((String)filenameOrURI), lang, baseIRI);
    }

    public static LabelToNode createLabelToNodeAsGivenOrRandom() {
        return new LabelToNode((MapWithScope.ScopePolicy)new AllocScopePolicy(), (MapWithScope.Allocator)new Alloc((BlankNodeAllocator)BlankNodeAllocatorAsGivenOrRandom.getGlobalInstance()));
    }

    public static ErrorHandler dftErrorHandler() {
        return ErrorHandlerFactory.errorHandlerWarn;
    }

    public static ParserProfile dftProfile() {
        return RDFDataMgrRx.permissiveProfile();
    }

    public static RDFParserBuilder applyParserDefaults(RDFParserBuilder builder) {
        return builder.resolver(IRIxResolverUtils.newIRIxResolverAsGiven()).errorHandler(RDFDataMgrRx.dftErrorHandler()).labelToNode(RDFDataMgrRx.createLabelToNodeAsGivenOrRandom());
    }

    public static ParserProfile createParserProfile(FactoryRDF factory, ErrorHandler errorHandler, boolean checking) {
        return new ParserProfileStd(factory, errorHandler, IRIxResolverUtils.newIRIxResolverAsGiven(), PrefixMapFactory.create(), RIOT.getContext().copy(), checking, false);
    }

    public static ParserProfile strictProfile() {
        return RDFDataMgrRx.createParserProfile(RiotLib.factoryRDF((LabelToNode)RDFDataMgrRx.createLabelToNodeAsGivenOrRandom()), ErrorHandlerFactory.errorHandlerExceptionOnError(), true);
    }

    public static ParserProfile permissiveProfile() {
        return RDFDataMgrRx.createParserProfile(RiotLib.factoryRDF((LabelToNode)RDFDataMgrRx.createLabelToNodeAsGivenOrRandom()), ErrorHandlerFactory.errorHandlerWarn, false);
    }

    public static void parseFromInputStream(StreamRDF destination, InputStream in, String baseUri, Lang lang, Context context) {
        RDFParser.create().source(in).resolver(IRIxResolverUtils.newIRIxResolverAsGiven()).base(baseUri).lang(lang).context(context).errorHandler(RDFDataMgrRx.dftErrorHandler()).labelToNode(RDFDataMgrRx.createLabelToNodeAsGivenOrRandom()).parse(destination);
    }

    public static Flowable<Quad> createFlowableQuads(String filenameOrURI, Lang lang, String baseIRI) {
        return RDFDataMgrRx.createFlowableQuads(() -> RDFDataMgr.open((String)filenameOrURI), lang, baseIRI);
    }

    public static Flowable<Quad> createFlowableQuads(Callable<InputStream> inSupplier, Lang lang, String baseIRI) {
        return FlowableEx.fromIteratorSupplier((ThrowingSupplier & Serializable)() -> AsyncParser.of((InputStream)((InputStream)inSupplier.call()), (Lang)lang, (String)baseIRI).mutateSources(source -> RDFDataMgrRx.applyParserDefaults(source)).asyncParseQuads(), Closeable::close).map(q -> q.getGraph() != null ? q : Quad.create((Node)Quad.defaultGraphNodeGenerated, (Triple)q.asTriple()));
    }

    public static Flowable<Resource> createFlowableResources(Callable<InputStream> inSupplier, Lang lang, String baseIRI) {
        Flowable result = RDFDataMgrRx.createFlowableQuads(inSupplier, lang, baseIRI).compose(FlowOfQuadsOps.groupToList()).map(Map.Entry::getValue).map(list -> list.stream().map(StreamUtils::decodeDistinguished).collect(Collectors.toList())).map(QuadPatternUtils::createResourceFromQuads);
        return result;
    }

    public static Flowable<Dataset> createFlowableDatasets(Callable<InputStream> inSupplier, Lang lang, String baseIRI) {
        Flowable result = RDFDataMgrRx.createFlowableQuads(inSupplier, lang, baseIRI).compose(FlowOfQuadsOps.datasetsFromConsecutiveQuads((SerializableFunction<Quad, Node>)((SerializableFunction & Serializable)Quad::getGraph), (SerializableSupplier<DatasetGraph>)((SerializableSupplier & Serializable)DatasetGraphFactoryEx::createInsertOrderPreservingDatasetGraph)));
        return result;
    }

    public static Flowable<Dataset> createFlowableDatasets(Callable<TypedInputStream> inSupplier) {
        Flowable result = RDFDataMgrRx.createFlowableQuads(inSupplier).compose(FlowOfQuadsOps.datasetsFromConsecutiveQuads((SerializableFunction<Quad, Node>)((SerializableFunction & Serializable)Quad::getGraph), (SerializableSupplier<DatasetGraph>)((SerializableSupplier & Serializable)DatasetGraphFactoryEx::createInsertOrderPreservingDatasetGraph)));
        return result;
    }

    public static Flowable<Quad> createFlowableQuads(Path path, Iterable<Lang> probeLangs) {
        return RDFDataMgrRx.createFlowableQuads(() -> RDFDataMgrEx.open(path, probeLangs));
    }

    public static Flowable<Quad> createFlowableQuads(Callable<TypedInputStream> inSupplier) {
        Flowable result = FlowableEx.fromIteratorSupplier((ThrowingSupplier & Serializable)() -> {
            TypedInputStream tis = (TypedInputStream)inSupplier.call();
            Lang lang = RDFLanguages.contentTypeToLang((String)tis.getContentType());
            String base = tis.getBaseURI();
            return AsyncParser.asyncParseQuads((InputStream)tis.getInputStream(), (Lang)lang, (String)base);
        }, Closeable::close);
        return result;
    }

    public static Flowable<Quad> createFlowableTriples(Path path, Iterable<Lang> probeLangs) {
        return RDFDataMgrRx.createFlowableQuads(() -> RDFDataMgrEx.open(path, probeLangs));
    }

    public static Flowable<Triple> createFlowableTriples(Callable<TypedInputStream> inSupplier) {
        Flowable result = FlowableEx.fromIteratorSupplier((ThrowingSupplier & Serializable)() -> {
            TypedInputStream tis = (TypedInputStream)inSupplier.call();
            Lang lang = RDFLanguages.contentTypeToLang((String)tis.getContentType());
            String base = tis.getBaseURI();
            return AsyncParser.asyncParseTriples((InputStream)tis.getInputStream(), (Lang)lang, (String)base);
        }, Closeable::close);
        return result;
    }

    public static void writeResources(Flowable<? extends Resource> flowable, Path file, RDFFormat format) throws Exception {
        RDFDataMgrRx.writeDatasets((Flowable<Dataset>)flowable.map(DatasetUtils::createFromResource), file, format);
    }

    public static void writeResources(Flowable<? extends Resource> flowable, OutputStream out, RDFFormat format) throws Exception {
        RDFDataMgrRx.writeDatasets((Flowable<Dataset>)flowable.map(DatasetUtils::createFromResource), out, format);
    }

    public static void writeDatasets(Flowable<Dataset> flowable, Path file, RDFFormat format) throws Exception {
        try (FileOutputStream out = new FileOutputStream(file.toFile());){
            RDFDataMgrRx.writeDatasets(flowable, out, format);
        }
    }

    public static FlowableTransformer<? super Dataset, Throwable> createWriterDataset(OutputStream out, RDFFormat format) {
        return upstream -> upstream.buffer(1).compose(RDFDataMgrRx.createBatchWriterDataset(out, format));
    }

    public static <C extends Collection<? extends Dataset>> FlowableTransformer<C, Throwable> createBatchWriterDataset(OutputStream out, RDFFormat format) {
        StreamUtils.QuadEncoderDistinguish encoder = new StreamUtils.QuadEncoderDistinguish();
        Lang lang = format.getLang();
        boolean isLangTriples = RDFLanguages.isTriples((Lang)lang);
        return upstream -> upstream.concatMapMaybe(batch -> {
            for (Dataset item : batch) {
                Dataset encoded = encoder.encode(item);
                if (isLangTriples) {
                    Iterator it = item.listNames();
                    while (it.hasNext()) {
                        String name = (String)it.next();
                        Model m = item.getNamedModel(name);
                        RDFDataMgr.write((OutputStream)out, (Model)m, (RDFFormat)format);
                    }
                    continue;
                }
                RDFDataMgr.write((OutputStream)out, (Dataset)encoded, (RDFFormat)format);
            }
            out.flush();
            return Maybe.empty();
        }).onErrorReturn(t -> t);
    }

    public static <C extends Collection<Quad>> FlowableTransformer<C, Throwable> createBatchWriterQuads(OutputStream out, RDFFormat format) {
        if (!Lang.NQUADS.equals((Object)format.getLang())) {
            throw new IllegalArgumentException("Only nquads based formats are currently supported");
        }
        return upstream -> upstream.concatMapMaybe(batch -> {
            RDFDataMgr.writeQuads((OutputStream)out, batch.iterator());
            out.flush();
            return Maybe.empty();
        }).onErrorReturn(t -> t);
    }

    public static <C extends Collection<Quad>> FlowableTransformer<C, Throwable> createBatchWriterQuads2(OutputStream out, RDFFormat format) {
        if (!Lang.NQUADS.equals((Object)format.getLang())) {
            throw new IllegalArgumentException("Only nquads based formats are currently supported");
        }
        return upstream -> upstream.concatMap(Flowable::fromIterable).reduceWith(() -> {
            StreamRDF s = StreamRDFWriterEx.getWriterStream((OutputStream)out, (RDFFormat)format, null);
            s.start();
            return s;
        }, (s, q) -> {
            s.quad(q);
            return s;
        }).doAfterSuccess(StreamRDF::finish).mapOptional(x -> Optional.empty()).onErrorReturn(t -> t).toFlowable();
    }

    public static void writeQuads(Flowable<Quad> flowable, OutputStream out, RDFFormat format) throws IOException {
        Flowable tmp = flowable.buffer(128).compose(RDFDataMgrRx.createBatchWriterQuads2(out, format));
        Throwable e = (Throwable)tmp.singleElement().blockingGet();
        if (e != null) {
            throw new IOException(e);
        }
    }

    public static void writeDatasets(Flowable<Dataset> flowable, OutputStream out, RDFFormat format) throws IOException {
        Flowable tmp = flowable.buffer(1).compose(RDFDataMgrRx.createBatchWriterDataset(out, format));
        Throwable e = (Throwable)tmp.singleElement().blockingGet();
        if (e != null) {
            throw new IOException(e);
        }
    }

    private static /* synthetic */ void lambda$writeDatasets$26(StreamUtils.QuadEncoderDistinguish encoder, OutputStream out, RDFFormat format, List items) throws Throwable {
        for (Dataset item : items) {
            Dataset encoded = encoder.encode(item);
            RDFDataMgr.write((OutputStream)out, (Dataset)encoded, (RDFFormat)format);
        }
        out.flush();
    }
}

