/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx;

import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Emitter;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableEmitter;
import io.reactivex.rxjava3.core.FlowableOnSubscribe;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.FlowableTransformer;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowableTransformerLocalOrderingOld<T, S>
implements Emitter<T> {
    private static final Logger logger = LoggerFactory.getLogger(FlowableTransformerLocalOrderingOld.class);
    protected FlowableEmitter<? super T> delegate;
    protected Function<? super T, ? extends S> extractSeqId;
    protected Function<? super S, ? extends S> incrementSeqId;
    protected BiFunction<? super S, ? super S, ? extends Number> distanceFn;
    protected S expectedSeqId;
    protected boolean isComplete = false;
    protected NavigableMap<S, T> seqIdToValue;

    public FlowableTransformerLocalOrderingOld(S expectedSeqId, Function<? super S, ? extends S> incrementSeqId, BiFunction<? super S, ? super S, ? extends Number> distanceFn, Function<? super T, ? extends S> extractSeqId, FlowableEmitter<? super T> delegate) {
        this.extractSeqId = extractSeqId;
        this.incrementSeqId = incrementSeqId;
        this.distanceFn = distanceFn;
        this.expectedSeqId = expectedSeqId;
        this.delegate = delegate;
        this.seqIdToValue = new TreeMap<S, T>((a, b) -> ((Number)distanceFn.apply(a, b)).intValue());
    }

    public void onError(Throwable throwable) {
        this.delegate.onError(throwable);
    }

    public void onComplete() {
        this.isComplete = true;
        if (this.seqIdToValue.isEmpty()) {
            this.delegate.onComplete();
        }
    }

    public void onNext(T value) {
        boolean checkForExistingKeys;
        S seqId = this.extractSeqId.apply(value);
        if (this.isComplete) {
            Object highestSeqId;
            if (this.seqIdToValue.isEmpty()) {
                this.onError(new RuntimeException("Sanity check failed: Call to onNext encountered after completion."));
            }
            if (this.distanceFn.apply(seqId, highestSeqId = this.seqIdToValue.descendingKeySet().first()).intValue() > 0) {
                this.onError(new RuntimeException("Sequence was marked as complete with id " + String.valueOf(highestSeqId) + " but a higher id was encountered " + String.valueOf(seqId)));
            }
        }
        if ((checkForExistingKeys = true) && this.seqIdToValue.containsKey(seqId)) {
            this.onError(new RuntimeException("Already seen an item with id " + String.valueOf(seqId)));
        }
        this.seqIdToValue.put(seqId, value);
        Iterator it = this.seqIdToValue.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            Object s = e.getKey();
            Object v = e.getValue();
            int d = this.distanceFn.apply(s, this.expectedSeqId).intValue();
            if (d == 0) {
                it.remove();
                this.delegate.onNext(v);
                this.expectedSeqId = this.incrementSeqId.apply(this.expectedSeqId);
                continue;
            }
            if (d < 0) {
                logger.warn("Should not happen: received id " + String.valueOf(s) + " which is lower than the expected id " + String.valueOf(this.expectedSeqId));
                it.remove();
                continue;
            }
            logger.trace("Received id " + String.valueOf(s) + " while waiting for expected id " + String.valueOf(this.expectedSeqId));
            break;
        }
        if (this.isComplete && this.seqIdToValue.isEmpty()) {
            this.delegate.onComplete();
        }
    }

    public static <T> Emitter<T> forLong(long initiallyExpectedId, Function<? super T, ? extends Long> extractSeqId, FlowableEmitter<? super T> delegate) {
        return new FlowableTransformerLocalOrderingOld<T, Long>(Long.valueOf(initiallyExpectedId), id -> id + 1L, (a, b) -> a - b, extractSeqId, delegate);
    }

    public static <T, S extends Comparable<S>> FlowableTransformerLocalOrderingOld<T, S> wrap(S initiallyExpectedId, Function<? super S, ? extends S> incrementSeqId, BiFunction<? super S, ? super S, ? extends Number> distanceFn, Function<? super T, ? extends S> extractSeqId, FlowableEmitter<? super T> delegate) {
        return new FlowableTransformerLocalOrderingOld<T, S>(initiallyExpectedId, incrementSeqId, distanceFn, extractSeqId, delegate);
    }

    public static <T, S extends Comparable<S>> FlowableTransformer<T, T> transformer(final S initiallyExpectedId, final Function<? super S, ? extends S> incrementSeqId, final BiFunction<? super S, ? super S, ? extends Number> distanceFn, final Function<? super T, ? extends S> extractSeqId) {
        return upstream -> {
            Flowable result = Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<T>(){

                public void subscribe(final FlowableEmitter<T> e) throws Exception {
                    final FlowableTransformerLocalOrderingOld tmp = FlowableTransformerLocalOrderingOld.wrap(initiallyExpectedId, incrementSeqId, distanceFn, extractSeqId, e);
                    upstream.subscribe(new FlowableSubscriber<T>(){

                        public void onSubscribe(Subscription s) {
                            e.setCancellable(() -> ((Subscription)s).cancel());
                            s.request(Long.MAX_VALUE);
                        }

                        public void onNext(T t) {
                            tmp.onNext(t);
                        }

                        public void onError(Throwable t) {
                            tmp.onError(t);
                        }

                        public void onComplete() {
                            tmp.onComplete();
                        }
                    });
                }
            }, (BackpressureStrategy)BackpressureStrategy.BUFFER);
            return result;
        };
    }
}

