/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx.io.resultset;

import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.jena_sparql_api.rx.io.resultset.SinkStreaming;
import org.aksw.jena_sparql_api.rx.io.resultset.SinkStreamingBase;
import org.aksw.jena_sparql_api.rx.io.resultset.SinkStreamingStreamRDF;
import org.aksw.jenax.arq.util.prefix.PrefixUtils;
import org.aksw.jenax.arq.util.streamrdf.StreamRDFDeferred;
import org.aksw.jenax.arq.util.triple.GraphUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.lang.SinkQuadsToDataset;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFWriter;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.Quad;

public class SinkStreamingQuads {
    public static SinkStreaming<Quad> createSinkQuads(final RDFFormat format, final OutputStream out, final PrefixMapping pm, long prefixAnalysis, Supplier<Dataset> datasetSupp) {
        StreamRDF writer;
        SinkStreamingStreamRDF result = null;
        boolean useStreaming = true;
        if (useStreaming && (writer = StreamRDFWriter.getWriterStream((OutputStream)out, (RDFFormat)format, null)) != null) {
            writer = new StreamRDFDeferred(writer, true, pm, prefixAnalysis, 100L * prefixAnalysis, null);
            result = new SinkStreamingStreamRDF(writer);
        }
        if (result == null) {
            final Dataset dataset = datasetSupp.get();
            final SinkQuadsToDataset core = new SinkQuadsToDataset(false, dataset.asDatasetGraph());
            return new SinkStreamingBase<Quad>(){

                @Override
                public void close() {
                    core.close();
                }

                @Override
                public void sendActual(Quad item) {
                    core.send(item);
                }

                public void flush() {
                    core.flush();
                }

                @Override
                public void finishActual() {
                    PrefixMappingImpl usedPrefixes = new PrefixMappingImpl();
                    Stream.concat(Stream.of(dataset.getDefaultModel()), Streams.stream((Iterator)dataset.listNames()).map(arg_0 -> ((Dataset)dataset).getNamedModel(arg_0))).forEach(arg_0 -> 1.lambda$finishActual$0(pm, (PrefixMapping)usedPrefixes, arg_0));
                    dataset.getDefaultModel().setNsPrefixes((PrefixMapping)usedPrefixes);
                    if (RDFLanguages.isTriples((Lang)format.getLang())) {
                        Iterator it = dataset.listNames();
                        if (it.hasNext()) {
                            int maxShow = 5;
                            List graphNames = Streams.stream((Iterator)it).limit(maxShow).collect(Collectors.toList());
                            int headCount = graphNames.size();
                            int totalCount = headCount + Iterators.size((Iterator)it);
                            throw new RuntimeException("Requested triple-based format " + String.valueOf(format) + " but named graphs in dataset. Showing " + headCount + " out of " + totalCount + ": " + String.valueOf(graphNames));
                        }
                        RDFDataMgr.write((OutputStream)out, (Model)dataset.getDefaultModel(), (RDFFormat)format);
                    } else {
                        RDFDataMgr.write((OutputStream)out, (Dataset)dataset, (RDFFormat)format);
                    }
                }

                private static /* synthetic */ void lambda$finishActual$0(PrefixMapping pm2, PrefixMapping usedPrefixes, Model m) {
                    try (Stream nodeStream = GraphUtils.streamNodes((Graph)m.getGraph());){
                        PrefixUtils.usedPrefixes((PrefixMapping)pm2, (Stream)nodeStream, (PrefixMapping)usedPrefixes);
                    }
                    m.clearNsPrefixMap();
                }
            };
        }
        return result;
    }
}

