/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.legacy;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.aksw.jena_sparql_api.legacy.CallableWithAbort;

public class CallableWithAbortFactory {
    protected volatile Thread thread;
    protected volatile boolean isDone = true;
    protected AtomicBoolean abortRequested = new AtomicBoolean();
    protected Predicate<? super Throwable> isAbortException;

    public CallableWithAbortFactory(Predicate<? super Throwable> isAbortException) {
        this.isAbortException = isAbortException;
    }

    public boolean isDone() {
        return this.isDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        boolean alreadyAbortRequested = this.abortRequested.getAndSet(true);
        if (!alreadyAbortRequested && !this.isDone) {
            CallableWithAbortFactory callableWithAbortFactory = this;
            synchronized (callableWithAbortFactory) {
                if (!this.isDone && this.thread != null) {
                    this.thread.interrupt();
                }
            }
        }
    }

    public <T> CallableWithAbort<T> setDelegate(Callable<T> delegate) {
        if (this.abortRequested.get()) {
            throw new IllegalStateException("Cannot set a new delegate after abort was requested");
        }
        if (!this.isDone) {
            throw new IllegalStateException("Cannot set a new delegate if the prior one has not completed execution");
        }
        return new CallableWithAbortImpl<T>(delegate);
    }

    public class CallableWithAbortImpl<T>
    implements CallableWithAbort<T> {
        protected Callable<T> delegate;

        public CallableWithAbortImpl(Callable<T> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            T result = null;
            CallableWithAbortFactory.this.thread = Thread.currentThread();
            if (Thread.interrupted() || CallableWithAbortFactory.this.abortRequested.get()) {
                CallableWithAbortFactory.this.isDone = true;
                throw new CancellationException();
            }
            try {
                CallableWithAbortFactory.this.isDone = false;
                if (!CallableWithAbortFactory.this.abortRequested.get()) {
                    result = this.delegate.call();
                }
            }
            catch (Exception e) {
                boolean isAborted = CallableWithAbortFactory.this.isAbortException.test(e);
                if (isAborted) {
                    throw new CancellationException();
                }
                throw new RuntimeException(e);
            }
            finally {
                CallableWithAbortFactory.this.isDone = true;
                if (CallableWithAbortFactory.this.abortRequested.get()) {
                    CallableWithAbortImpl callableWithAbortImpl = this;
                    synchronized (callableWithAbortImpl) {
                        boolean bl = Thread.interrupted();
                    }
                }
            }
            return result;
        }

        @Override
        public void abort() {
            CallableWithAbortFactory.this.abort();
        }
    }
}

