/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.concept.parser;

import java.util.ArrayList;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aksw.jena_sparql_api.concept.parser.SparqlRelationParser;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.impl.Fragment2Impl;
import org.aksw.jenax.stmt.parser.element.SparqlElementParserImpl;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.syntax.Element;

public class SparqlRelationParserImpl
implements SparqlRelationParser {
    private Function<String, Element> elementParser;
    public static String VAR_PATTERN_STR = "\\?(\\w|_)+";
    public static Pattern VAR_PATTERN = Pattern.compile(VAR_PATTERN_STR);

    public SparqlRelationParserImpl() {
        this((Function<String, Element>)new SparqlElementParserImpl());
    }

    public SparqlRelationParserImpl(Function<String, Element> elementParser) {
        this.elementParser = elementParser;
    }

    public Fragment2 apply(String input) {
        Fragment2 result = SparqlRelationParserImpl.parse(input, this.elementParser);
        return result;
    }

    public static Fragment2 parse(String relationStr, Function<String, Element> elementParser) {
        String[] splits = relationStr.split("\\|", 2);
        if (splits.length != 2) {
            throw new RuntimeException("Invalid string: " + relationStr);
        }
        String varsStr = splits[0];
        Matcher m = VAR_PATTERN.matcher(varsStr);
        ArrayList<Var> vars = new ArrayList<Var>();
        while (m.find()) {
            String varName = m.group(1);
            Var v = Var.alloc((String)varName);
            vars.add(v);
        }
        if (vars.size() != 2) {
            throw new RuntimeException("Exactly 2 variables expected, instead got: " + varsStr);
        }
        Var sourceVar = (Var)vars.get(0);
        Var targetVar = (Var)vars.get(1);
        String elementStr = splits[1];
        Element element = elementParser.apply(elementStr);
        Fragment2Impl result = new Fragment2Impl(element, sourceVar, targetVar);
        return result;
    }

    public static SparqlRelationParserImpl create(Syntax syntax, Prologue prologue) {
        SparqlElementParserImpl elementParser = SparqlElementParserImpl.create((Syntax)syntax, (Prologue)prologue);
        SparqlRelationParserImpl result = new SparqlRelationParserImpl((Function<String, Element>)elementParser);
        return result;
    }
}

