/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.fragment.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.commons.collections.MapUtils;
import org.aksw.commons.collections.SetUtils;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.commons.collections.generator.GeneratorBlacklist;
import org.aksw.jenax.arq.util.expr.ExprListUtils;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.syntax.QueryGenerationUtils;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.arq.util.syntax.VarExprListUtils;
import org.aksw.jenax.arq.util.triple.Triples;
import org.aksw.jenax.arq.util.var.VarGeneratorBlacklist;
import org.aksw.jenax.arq.util.var.VarGeneratorImpl2;
import org.aksw.jenax.arq.util.var.VarUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.aksw.jenax.sparql.fragment.impl.OrderedConcept;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.SortCondition;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.AggCount;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementOptional;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.PatternVars;
import org.apache.jena.vocabulary.RDF;

public class ConceptUtils {
    public static final Fragment1 subjectConcept = ConceptUtils.createSubjectConcept();
    public static Fragment1 listDeclaredProperties = Concept.create("?s a ?t . Filter(?t = <http://www.w3.org/1999/02/22-rdf-syntax-ns#Property> || ?t = <http://www.w3.org/2002/07/owl#ObjectProperty> || ?t = <http://www.w3.org/2002/07/owl#DataTypeProperty>)", "s");
    public static Fragment1 listDeclaredClasses = Concept.create("?s a ?t . Filter(?t = <http://www.w3.org/2000/01/rdf-schema#Class> || ?t = <http://www.w3.org/2002/07/owl#Class>)", "s");
    public static Fragment1 listUsedClasses = Concept.create("?s a ?t", "t");
    public static Fragment1 listAllPredicates = Concept.create("?s ?p ?o", "p");
    public static Fragment1 listAllGraphsLegacy = Concept.create("Graph ?g { ?s ?p ?o }", "g");
    public static Fragment1 listAllGraphs = Concept.create("Graph ?g { }", "g");

    public static Fragment1 createPredicateQuery(Fragment1 concept) {
        Collection vars = PatternVars.vars((Element)concept.getElement());
        Var s = concept.getVar();
        GeneratorBlacklist gen = GeneratorBlacklist.create((Generator)VarGeneratorImpl2.create((String)"v"), (Collection)vars);
        Var p = Var.alloc((Var)((Var)gen.next()));
        Var o = Var.alloc((Var)((Var)gen.next()));
        Triple triple = Triple.create((Node)s, (Node)p, (Node)o);
        BasicPattern bp = new BasicPattern();
        bp.add(triple);
        List<Element> elements = concept.isSubjectConcept() ? new ArrayList<Element>() : concept.getElements();
        elements.add((Element)new ElementTriplesBlock(bp));
        Concept result = new Concept(elements, p);
        return result;
    }

    public static boolean isSubjectConcept(Fragment1 r) {
        List triples;
        Element element = r.getElement();
        Var var = r.getVar();
        if (element instanceof ElementTriplesBlock && (triples = ((ElementTriplesBlock)element).getPattern().getList()).size() == 1) {
            boolean condition;
            Triple triple = (Triple)triples.get(0);
            boolean bl = condition = triple.getSubject().isVariable() && triple.getSubject().equals((Object)var) && triple.getPredicate().isVariable() && triple.getObject().isVariable();
            if (condition) {
                return true;
            }
        }
        return false;
    }

    public static Fragment1 makeDistinctFrom(Fragment1 a, Fragment1 that) {
        Element newElement;
        HashSet thisVarNames = new HashSet(VarUtils.getVarNames((Iterable)PatternVars.vars((Element)a.getElement())));
        HashSet thatVarNames = new HashSet(VarUtils.getVarNames((Iterable)PatternVars.vars((Element)that.getElement())));
        Sets.SetView commonVarNames = Sets.intersection(thisVarNames, thatVarNames);
        Sets.SetView combinedVarNames = Sets.union(thisVarNames, thatVarNames);
        GeneratorBlacklist generator = GeneratorBlacklist.create((Generator)VarGeneratorImpl2.create((String)"v"), (Collection)combinedVarNames);
        BindingBuilder builder = BindingBuilder.create();
        for (String varName : commonVarNames) {
            Var oldVar = Var.alloc((String)varName);
            Var newVar = Var.alloc((Var)((Var)generator.next()));
            builder.add(oldVar, (Node)newVar);
        }
        Binding binding = builder.build();
        Op op = Algebra.compile((Element)a.getElement());
        Op substOp = Substitute.substitute((Op)op, (Binding)binding);
        if (substOp instanceof OpBGP) {
            BasicPattern bp = ((OpBGP)substOp).getPattern();
            newElement = new ElementTriplesBlock(bp);
        } else {
            Query tmp = OpAsQuery.asQuery((Op)substOp);
            newElement = tmp.getQueryPattern();
        }
        Var tmpVar = (Var)binding.get(a.getVar());
        Var newVar = tmpVar != null ? tmpVar : a.getVar();
        Concept result = new Concept(newElement, newVar);
        return result;
    }

    public static Fragment1 createConcept(Node ... nodes) {
        Fragment1 result = ConceptUtils.createConcept(Arrays.asList(nodes));
        return result;
    }

    public static Fragment1 createConceptFromRdfNodes(Iterable<? extends RDFNode> rdfNodes) {
        Iterable nodes = Streams.stream(rdfNodes).map(FrontsNode::asNode).collect(Collectors.toList());
        Fragment1 result = ConceptUtils.createConcept(nodes);
        return result;
    }

    public static Fragment1 createConcept(Iterable<? extends Node> nodes) {
        ElementData data = new ElementData();
        data.add(Vars.s);
        for (Node node : nodes) {
            Binding binding = BindingFactory.binding((Var)Vars.s, (Node)node);
            data.add(binding);
        }
        Concept result = new Concept((Element)data, Vars.s);
        return result;
    }

    public static Fragment1 createFilterConcept(Node ... nodes) {
        Fragment1 result = ConceptUtils.createFilterConcept(Arrays.asList(nodes));
        return result;
    }

    public static Fragment1 createFilterConcept(Iterable<Node> nodes) {
        int size = Iterables.size(nodes);
        Concept result = new Concept((Element)(switch (size) {
            case 0 -> new ElementFilter((Expr)NodeValue.FALSE);
            case 1 -> {
                Node node = nodes.iterator().next();
                yield new ElementFilter((Expr)new E_Equals((Expr)new ExprVar(Vars.s), (Expr)NodeValue.makeNode((Node)node)));
            }
            default -> new ElementFilter((Expr)new E_OneOf((Expr)new ExprVar(Vars.s), ExprListUtils.nodesToExprs(nodes)));
        }), Vars.s);
        return result;
    }

    public static Fragment1 createRelatedConcept(Collection<Node> nodes, Fragment2 relation) {
        Var sourceVar = relation.getSourceVar();
        Var targetVar = relation.getTargetVar();
        Element relationEl = relation.getElement();
        ExprVar ev = new ExprVar(sourceVar);
        ExprList el = ExprListUtils.nodesToExprs(nodes);
        ElementFilter filterEl = new ElementFilter((Expr)new E_OneOf((Expr)ev, el));
        Element resultEl = ElementUtils.mergeElements((Element)relationEl, (Element)filterEl);
        Concept result = new Concept(resultEl, targetVar);
        return result;
    }

    public static Fragment1 getRelatedConcept(Fragment1 source, Fragment2 relation) {
        Fragment1 renamedSource = ConceptUtils.createRenamedSourceConcept(source, relation);
        Element merged = ElementUtils.mergeElements((Element)renamedSource.getElement(), (Element)relation.getElement());
        Var targetVar = relation.getTargetVar();
        Concept result = new Concept(merged, targetVar);
        return result;
    }

    public static Query createQueryCount(Fragment1 concept, Var outputVar, Long itemLimit, Long rowLimit) {
        Query subQuery = ConceptUtils.createQueryList(concept);
        if (rowLimit != null) {
            subQuery.setDistinct(false);
            subQuery.setLimit(rowLimit.longValue());
            subQuery = QueryGenerationUtils.wrapAsSubQuery((Query)subQuery, (Var)concept.getVar());
            subQuery.setDistinct(true);
        }
        if (itemLimit != null) {
            subQuery.setLimit(itemLimit.longValue());
        }
        ElementSubQuery esq = new ElementSubQuery(subQuery);
        Query result = new Query();
        result.setQuerySelectType();
        Expr ea = result.allocAggregate((Aggregator)new AggCount());
        result.getProject().add(outputVar, ea);
        result.setQueryPattern((Element)esq);
        return result;
    }

    public static Set<Var> getVarsMentioned(Fragment1 concept) {
        Collection tmp = PatternVars.vars((Element)concept.getElement());
        Set result = SetUtils.asSet((Iterable)tmp);
        return result;
    }

    public static Fragment1 createSubjectConcept() {
        ElementTriplesBlock e = new ElementTriplesBlock();
        e.addTriple(Triples.spo);
        Concept result = new Concept((Element)e, Vars.s);
        return result;
    }

    public static Fragment1 empty(Var var) {
        Concept result = new Concept((Element)new ElementGroup(), var);
        return result;
    }

    public static Fragment1 createForRdfType(String iriStr) {
        return ConceptUtils.createForRdfType(NodeFactory.createURI((String)iriStr));
    }

    public static Fragment1 createForRdfType(Node type) {
        Concept result = new Concept((Element)ElementUtils.createElementTriple((Node)Vars.s, (Node)RDF.Nodes.type, (Node)type), Vars.s);
        return result;
    }

    public static Fragment1 createForSubjectsOfPredicate(String iriStr) {
        return ConceptUtils.createForSubjectsOfPredicate(NodeFactory.createURI((String)iriStr));
    }

    public static Fragment1 createForSubjectsOfPredicate(Node predicate) {
        Concept result = new Concept((Element)ElementUtils.createElementTriple((Node)Vars.s, (Node)predicate, (Node)Vars.o), Vars.s);
        return result;
    }

    public static Map<Var, Var> createDistinctVarMap(Set<Var> workload, Set<Var> blacklist, Generator<Var> generator) {
        HashMap<Var, Var> result = new HashMap<Var, Var>();
        for (Var var : workload) {
            boolean isBlacklisted = blacklist.contains(var);
            Var t = isBlacklisted ? (Var)generator.next() : var;
            result.put(var, t);
        }
        return result;
    }

    public static Generator<Var> createGenerator(Fragment1 concept) {
        Collection tmp = PatternVars.vars((Element)concept.getElement());
        VarGeneratorBlacklist result = VarGeneratorBlacklist.create((String)"v", (Collection)tmp);
        return result;
    }

    public static Fragment1 renameVar(Fragment1 concept, Var targetVar) {
        Fragment1 result;
        if (concept.getVar().equals((Object)targetVar)) {
            result = concept;
        } else {
            Set<Var> conceptVars = ConceptUtils.getVarsMentioned(concept);
            Map<Var, Var> varMap = ConceptUtils.createDistinctVarMap(conceptVars, Collections.singleton(targetVar), (Generator<Var>)VarGeneratorImpl2.create((String)"v"));
            varMap.put(concept.getVar(), targetVar);
            Element replElement = ElementUtils.createRenamedElement((Element)concept.getElement(), varMap);
            Var replVar = varMap.get(concept.getVar());
            result = new Concept(replElement, replVar);
        }
        return result;
    }

    public static Map<Var, Var> createVarMap(Fragment1 attrConcept, Fragment1 filterConcept) {
        Element attrElement = attrConcept.getElement();
        Element filterElement = filterConcept.getElement();
        Collection attrVars = PatternVars.vars((Element)attrElement);
        Collection filterVars = PatternVars.vars((Element)filterElement);
        List<Var> attrJoinVars = Collections.singletonList(attrConcept.getVar());
        List<Var> filterJoinVars = Collections.singletonList(filterConcept.getVar());
        Map result = VarUtils.createJoinVarMap((Collection)attrVars, (Collection)filterVars, attrJoinVars, filterJoinVars, null);
        return result;
    }

    public static Fragment1 createRenamedSourceConcept(Fragment1 concept, Fragment2 relation) {
        Concept attrConcept = new Concept(relation.getElement(), relation.getSourceVar());
        Fragment1 result = ConceptUtils.createRenamedConcept((Fragment1)attrConcept, concept);
        return result;
    }

    public static Fragment1 createRenamedConcept(Fragment1 concept, Map<Var, Var> varMap) {
        Var newVar = (Var)MapUtils.getOrElse(varMap, (Object)concept.getVar(), (Object)concept.getVar());
        Element newElement = ElementUtils.createRenamedElement((Element)concept.getElement(), varMap);
        Concept result = new Concept(newElement, newVar);
        return result;
    }

    public static Fragment1 createRenamedConcept(Fragment1 attrConcept, Fragment1 filterConcept) {
        Map<Var, Var> varMap = ConceptUtils.createVarMap(attrConcept, filterConcept);
        Var attrVar = attrConcept.getVar();
        Element filterElement = filterConcept.getElement();
        Element newFilterElement = ElementUtils.createRenamedElement((Element)filterElement, varMap);
        Concept result = new Concept(newFilterElement, attrVar);
        return result;
    }

    public static Fragment1 createCombinedConcept(Fragment1 attrConcept, Fragment1 filterConcept, boolean renameVars, boolean attrsOptional, boolean filterAsSubquery) {
        Element e;
        Var attrVar = attrConcept.getVar();
        Var filterVar = filterConcept.getVar();
        if (!filterVar.equals((Object)attrVar)) {
            HashMap<Var, Var> varMap = new HashMap<Var, Var>();
            varMap.put(filterVar, attrVar);
            Var distinctAttrVar = Var.alloc((String)("cc_" + attrVar.getName()));
            varMap.put(attrVar, distinctAttrVar);
            filterConcept = ConceptUtils.createRenamedConcept(filterConcept, varMap);
        }
        Fragment1 tmpConcept = renameVars ? ConceptUtils.createRenamedConcept(attrConcept, filterConcept) : filterConcept;
        List<Element> tmpElements = tmpConcept.getElements();
        Element attrElement = attrConcept.getElement();
        if (!tmpElements.isEmpty()) {
            if (tmpConcept.isSubjectConcept()) {
                e = attrConcept.getElement();
            } else {
                ArrayList<Element> newElements = new ArrayList<Element>();
                if (attrsOptional) {
                    attrElement = new ElementOptional(attrConcept.getElement());
                }
                newElements.add(attrElement);
                if (filterAsSubquery) {
                    tmpElements = Collections.singletonList(new ElementSubQuery(tmpConcept.asQuery()));
                }
                newElements.addAll(tmpElements);
                e = ElementUtils.createElementGroup(newElements);
            }
        } else {
            e = attrElement;
        }
        Concept result = new Concept(e, attrVar);
        return result;
    }

    public static boolean isGroupedOnlyByVar(Query query, Var groupVar) {
        Expr expr;
        boolean hasOneGroup;
        boolean result = false;
        boolean bl = hasOneGroup = query.getGroupBy().size() == 1;
        if (hasOneGroup && (expr = (Expr)query.getGroupBy().getExprs().values().iterator().next()) instanceof ExprVar) {
            Var v = expr.asVar();
            result = v.equals((Object)groupVar);
        }
        return result;
    }

    public static boolean isDistinctConceptVar(Query query, Var conceptVar) {
        boolean isDistinct = query.isDistinct();
        List projectVars = query.getProjectVars();
        boolean hasSingleVar = !query.isQueryResultStar() && projectVars != null && projectVars.size() == 1;
        boolean result = isDistinct && hasSingleVar && ((Var)projectVars.iterator().next()).equals((Object)conceptVar);
        return result;
    }

    public static boolean isConceptQuery(Query query, Var conceptVar) {
        boolean isDistinctGroupByVar = ConceptUtils.isGroupedOnlyByVar(query, conceptVar);
        boolean isDistinctConceptVar = ConceptUtils.isDistinctConceptVar(query, conceptVar);
        boolean result = isDistinctGroupByVar || isDistinctConceptVar;
        return result;
    }

    public static Query createQueryList(Fragment1 concept) {
        Query result = ConceptUtils.createQueryList(concept, null, null);
        return result;
    }

    public static Query createQueryList(OrderedConcept orderedConcept, Range<Long> range) {
        Fragment1 concept = orderedConcept.getConcept();
        Query result = ConceptUtils.createQueryList(concept, range);
        for (SortCondition sc : orderedConcept.getOrderBy()) {
            result.addOrderBy(sc);
        }
        return result;
    }

    public static Query createQueryList(OrderedConcept orderedConcept, Long limit, Long offset) {
        Fragment1 concept = orderedConcept.getConcept();
        Query result = ConceptUtils.createQueryList(concept, limit, offset);
        for (SortCondition sc : orderedConcept.getOrderBy()) {
            result.addOrderBy(sc);
        }
        return result;
    }

    public static Query createQueryList(Fragment1 concept, Range<Long> range) {
        long offset = QueryUtils.rangeToOffset(range);
        long limit = QueryUtils.rangeToLimit(range);
        Query result = ConceptUtils.createQueryList(concept, (Long)limit, (Long)offset);
        return result;
    }

    public static Query createQueryList(Fragment1 concept, Long limit, Long offset) {
        Query result = new Query();
        result.setQuerySelectType();
        result.setDistinct(true);
        result.setLimit(limit == null ? Long.MIN_VALUE : limit);
        result.setOffset(offset == null ? Long.MIN_VALUE : offset);
        result.getProject().add(concept.getVar());
        Element e = concept.getElement();
        if (e instanceof ElementSubQuery) {
            e = ElementUtils.createElementGroup((Element[])new Element[]{e});
        }
        result.setQueryPattern(e);
        return result;
    }

    public static Query createAttrQuery(Query attrQuery, Var attrVar, boolean isLeftJoin, Fragment1 filterConcept, Long limit, Long offset, boolean forceSubQuery) {
        Query result;
        Concept attrConcept = new Concept((Element)new ElementSubQuery(attrQuery), attrVar);
        Fragment1 renamedFilterConcept = ConceptUtils.createRenamedConcept((Fragment1)attrConcept, filterConcept);
        boolean isAttrVarPrimaryKey = ConceptUtils.isConceptQuery(attrQuery, attrVar);
        if (isAttrVarPrimaryKey) {
            Element se;
            result = attrQuery.cloneQuery();
            if (forceSubQuery) {
                Query sq = new Query();
                sq.setQuerySelectType();
                sq.setDistinct(true);
                sq.getProject().add(attrConcept.getVar());
                sq.setQueryPattern(attrQuery.getQueryPattern());
                ElementSubQuery tmp = new ElementSubQuery(sq);
                Set refVars = VarExprListUtils.getRefVars((VarExprList)attrQuery.getProject());
                if (refVars.size() == 1 && attrVar.equals(refVars.iterator().next())) {
                    se = tmp;
                } else {
                    ElementGroup foo = new ElementGroup();
                    foo.addElement(attrQuery.getQueryPattern());
                    foo.addElement((Element)tmp);
                    se = foo;
                }
            } else {
                se = attrQuery.getQueryPattern();
            }
            if (isLeftJoin) {
                se = new ElementOptional(se);
            }
            if (!renamedFilterConcept.isSubjectConcept()) {
                ElementGroup newElement = ElementUtils.createElementGroup((Element[])new Element[]{renamedFilterConcept.getElement(), se});
                result.setQueryPattern((Element)newElement);
            }
            result.setLimit(limit.longValue());
            result.setOffset(offset.longValue());
        } else {
            Element newFilterElement;
            boolean requireSubQuery;
            boolean bl = requireSubQuery = QueryUtils.hasLimit((Long)limit) || QueryUtils.hasNonZeroOffset((Long)offset);
            if (requireSubQuery) {
                Fragment1 subConcept;
                if (isLeftJoin) {
                    subConcept = renamedFilterConcept;
                } else {
                    Object subElement = renamedFilterConcept.isSubjectConcept() ? attrQuery.getQueryPattern() : ElementUtils.createElementGroup((Element[])new Element[]{attrQuery.getQueryPattern(), renamedFilterConcept.getElement()});
                    subConcept = new Concept((Element)subElement, attrVar);
                }
                Query subQuery = ConceptUtils.createQueryList(subConcept, limit, offset);
                newFilterElement = new ElementSubQuery(subQuery);
            } else {
                newFilterElement = renamedFilterConcept.getElement();
            }
            Query query = attrQuery.cloneQuery();
            Element attrElement = query.getQueryPattern();
            Object newAttrElement = !requireSubQuery && filterConcept != null && filterConcept.isSubjectConcept() ? attrElement : (isLeftJoin ? ElementUtils.createElementGroup((Element[])new Element[]{newFilterElement, new ElementOptional(attrElement)}) : ElementUtils.createElementGroup((Element[])new Element[]{attrElement, newFilterElement}));
            query.setQueryPattern(newAttrElement);
            result = query;
        }
        return result;
    }

    public static Var freshVar(Fragment1 concept) {
        Var result = ConceptUtils.freshVar(concept, null);
        return result;
    }

    public static Var freshVar(Fragment1 concept, String baseVarName) {
        baseVarName = baseVarName == null ? "c" : baseVarName;
        Set<Var> varsMentioned = concept.getVarsMentioned();
        Generator varGen = VarUtils.createVarGen((String)baseVarName, varsMentioned);
        Var result = (Var)varGen.next();
        return result;
    }

    public static Fragment1 createRenamedConcept(Fragment1 concept, Var attrVar) {
        Var newVar = ConceptUtils.freshVar(concept);
        HashMap<Var, Var> varMap = new HashMap<Var, Var>();
        varMap.put(attrVar, newVar);
        varMap.put(concept.getVar(), attrVar);
        Fragment1 result = ConceptUtils.createRenamedConcept(concept, varMap);
        return result;
    }
}

