/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.fragment.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.jenax.arq.util.node.NodeTransformRenameMap;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.var.VarUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.aksw.jenax.sparql.fragment.impl.OrderedConcept;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.aggregate.AggCountVar;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.syntaxtransform.NodeTransformSubst;

public class ConceptOps {
    public static List<SortCondition> transform(NodeTransform nodeTransform, List<SortCondition> conditions) {
        ArrayList<SortCondition> conditions2 = new ArrayList<SortCondition>();
        boolean same = true;
        for (SortCondition sc : conditions) {
            Expr expr2;
            Expr expr = sc.getExpression();
            if (expr != (expr2 = NodeTransformLib.transform((NodeTransform)nodeTransform, (Expr)expr))) {
                same = false;
            }
            SortCondition sc2 = new SortCondition(expr2, sc.getDirection());
            conditions2.add(sc2);
        }
        if (same) {
            return conditions;
        }
        return conditions2;
    }

    public static OrderedConcept applyOrder(Fragment1 concept, OrderedConcept ordered, Generator<Var> generator) {
        Map<Var, Var> varMap = ConceptOps.createAlignedVarMap(concept, ordered.getConcept(), generator);
        Fragment1 tmp = ConceptOps.intersect2(concept, ordered.getConcept(), varMap);
        List<SortCondition> orderBy = ConceptOps.transform((NodeTransform)new NodeTransformSubst(varMap), ordered.getOrderBy());
        OrderedConcept result = new OrderedConcept(tmp, orderBy);
        return result;
    }

    public static Fragment1 forAllIfRolePresent(Fragment2 role, Fragment1 filler, Generator<Var> generator) {
        Fragment1 result;
        if (filler == Concept.TOP) {
            result = ConceptOps.exists(role, filler, generator);
        } else {
            Var sourceVar = role.getSourceVar();
            Var targetVar = role.getTargetVar();
            Var cnta = (Var)generator.next();
            Var cntb = (Var)generator.next();
            Element roleElement = role.getElement();
            ExprVar targetEv = new ExprVar(targetVar);
            Query qa = new Query();
            qa.setQuerySelectType();
            VarExprList pa = qa.getProject();
            pa.add(sourceVar);
            pa.add(cnta, (Expr)new ExprAggregator(Vars.x, (Aggregator)new AggCountVar((Expr)targetEv)));
            qa.setQueryPattern(roleElement);
            qa.addGroupBy((Node)sourceVar);
            Query qb = new Query();
            qb.setQuerySelectType();
            VarExprList pb = qb.getProject();
            pb.add(sourceVar);
            pb.add(cntb, (Expr)new ExprAggregator(Vars.y, (Aggregator)new AggCountVar((Expr)targetEv)));
            Fragment1 aligned = ConceptOps.align(filler, role.getTargetConcept(), generator);
            Element x = ElementUtils.mergeElements((Element)roleElement, (Element)aligned.getElement());
            qb.setQueryPattern(x);
            qb.addGroupBy((Node)sourceVar);
            ElementGroup e = new ElementGroup();
            e.addElement((Element)new ElementSubQuery(qa));
            e.addElement((Element)new ElementSubQuery(qb));
            e.addElement((Element)new ElementFilter((Expr)new E_Equals((Expr)new ExprVar(cnta), (Expr)new ExprVar(cntb))));
            result = new Concept((Element)e, sourceVar);
        }
        return result;
    }

    public static Fragment1 exists(Fragment2 relation, Fragment1 filler, Generator<Var> generator) {
        Concept targetConcept = relation.getTargetConcept();
        Fragment1 aligned = ConceptOps.align(filler, targetConcept, generator);
        Element x = ElementUtils.mergeElements((Element)relation.getElement(), (Element)aligned.getElement());
        Concept result = new Concept(x, relation.getSourceVar());
        return result;
    }

    public static Fragment1 align(Fragment1 concept, Set<Var> vbs, Var vbJoinVar, Generator<Var> generator) {
        Map<Var, Var> varMap = ConceptOps.createAlignedVarMap(concept, vbs, vbJoinVar, generator);
        Fragment1 result = ConceptOps.applyNodeTransform(concept, varMap);
        return result;
    }

    public static Fragment1 applyNodeTransform(Fragment1 concept, Map<? extends Node, ? extends Node> nodeMap) {
        NodeTransformRenameMap nodeTransform = NodeTransformRenameMap.create(nodeMap);
        Fragment1 result = concept.applyNodeTransform((NodeTransform)nodeTransform).toFragment1();
        return result;
    }

    public static Map<Var, Var> createAlignedVarMap(Fragment1 concept, Set<Var> vbs, Var vbJoinVar, Generator<Var> generator) {
        Set<Var> vas = concept.getVarsMentioned();
        Map result = VarUtils.createDistinctVarMap(vas, vbs, (boolean)true, generator);
        result.put(concept.getVar(), vbJoinVar);
        return result;
    }

    public static Map<Var, Var> createAlignedVarMap(Fragment1 concept, Fragment1 forbiddenVars, Generator<Var> generator) {
        Var vb = forbiddenVars.getVar();
        Set<Var> vbs = forbiddenVars.getVarsMentioned();
        Map<Var, Var> result = ConceptOps.createAlignedVarMap(concept, vbs, vb, generator);
        return result;
    }

    public static Fragment1 align(Fragment1 alignee, Fragment1 forbiddenVars, Generator<Var> generator) {
        Set<Var> vbs = forbiddenVars.getVarsMentioned();
        Fragment1 result = ConceptOps.align(alignee, vbs, forbiddenVars.getVar(), generator);
        return result;
    }

    public static Fragment1 union(Stream<Fragment1> conceptStream) {
        Fragment1 result = conceptStream.reduce(Concept.BOTTOM, (x, y) -> ConceptOps.union(y, x, null));
        return result;
    }

    public static Fragment1 intersect(Stream<Fragment1> conceptStream) {
        Fragment1 result = conceptStream.reduce(Concept.TOP, (x, y) -> ConceptOps.intersect(y, x, (Generator<Var>)((Generator)null)));
        return result;
    }

    public static Fragment1 union(Fragment1 concept, Fragment1 filter, Generator<Var> generator) {
        Fragment1 result;
        if (filter != null && filter != Concept.BOTTOM) {
            Fragment1 tmp = ConceptOps.align(concept, filter, generator);
            Element e = ElementUtils.unionElements((Element)concept.getElement(), (Element)tmp.getElement());
            result = new Concept(e, concept.getVar());
        } else {
            result = concept;
        }
        return result;
    }

    public static Fragment1 intersect2(Fragment1 concept, Fragment1 filter, Map<Var, Var> varMap) {
        Fragment1 result;
        if (filter != null) {
            Fragment1 tmp = varMap == null ? filter : ConceptOps.applyNodeTransform(filter, varMap);
            Element e = ElementUtils.mergeElements((Element)concept.getElement(), (Element)tmp.getElement());
            result = new Concept(e, concept.getVar());
        } else {
            result = concept;
        }
        return result;
    }

    public static Fragment1 intersect(Fragment1 concept, Fragment1 filter, Generator<Var> generator) {
        Fragment1 result;
        if (filter != null) {
            Fragment1 tmp = ConceptOps.align(filter, concept, generator);
            Element e = ElementUtils.mergeElements((Element)concept.getElement(), (Element)tmp.getElement());
            result = new Concept(e, concept.getVar());
        } else {
            result = concept;
        }
        return result;
    }
}

