/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.fragment.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.var.VarGeneratorBlacklist;
import org.aksw.jenax.arq.util.var.VarUtils;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.impl.FragmentImpl;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementOptional;

public class FragmentJoiner {
    protected Fragment attrRelation;
    protected List<Var> attrJoinVars;
    protected Fragment filterRelation;
    protected List<Var> filterJoinVars;
    protected boolean filterRelationFirst;
    protected Map<Var, Boolean> varToOrigin = null;

    public FragmentJoiner(Fragment attrRelation, List<Var> attrJoinVars) {
        this(attrRelation, attrJoinVars, false);
    }

    public FragmentJoiner(Fragment attrRelation, List<Var> attrJoinVars, boolean filterRelationFirst) {
        this.attrRelation = attrRelation;
        this.attrJoinVars = attrJoinVars;
        this.filterRelationFirst = filterRelationFirst;
    }

    public static FragmentJoiner from(Fragment r, Var ... vars) {
        return FragmentJoiner.from(r, Arrays.asList(vars));
    }

    public static FragmentJoiner from(Fragment r, List<Var> vars) {
        FragmentJoiner result = new FragmentJoiner(r, new ArrayList<Var>(vars));
        return result;
    }

    public FragmentJoiner addAttrJoinVar(Var var) {
        this.attrJoinVars.add(var);
        return this;
    }

    public FragmentJoiner filterRelationFirst(boolean onOrOff) {
        this.filterRelationFirst = onOrOff;
        return this;
    }

    public FragmentJoiner projectSrcVars(Var ... vars) {
        this.varToOrigin = this.varToOrigin != null ? this.varToOrigin : new LinkedHashMap<Var, Boolean>();
        for (Var v : vars) {
            Boolean prior = this.varToOrigin.put(v, true);
            if (prior == null) continue;
            throw new RuntimeException("Variable " + String.valueOf(v) + " was already projected; prior value: " + prior + " - current value: true");
        }
        return this;
    }

    public FragmentJoiner projectTgtVars(Var ... vars) {
        this.varToOrigin = this.varToOrigin != null ? this.varToOrigin : new LinkedHashMap<Var, Boolean>();
        for (Var v : vars) {
            Boolean prior = this.varToOrigin.put(v, false);
            if (prior == null) continue;
            throw new RuntimeException("Variable " + String.valueOf(v) + " was already projected; prior value: " + prior + " - current value: false");
        }
        return this;
    }

    public Fragment with(Fragment c, Var ... joinVars) {
        Fragment result;
        if (c != null) {
            this.filterRelation = c;
            this.filterJoinVars = joinVars.length == 0 ? c.getVars() : Arrays.asList(joinVars);
            result = this.get();
        } else {
            result = this.attrRelation;
        }
        return result;
    }

    public Fragment with(Fragment1 ur) {
        return this.with(ur, ur.getVar());
    }

    public Fragment yieldRenamedFilter(Fragment c) {
        this.filterRelation = c;
        this.filterJoinVars = c.getVars();
        Fragment result = this.yieldRenamedFilterCore();
        return result;
    }

    public Fragment yieldRenamedFilterCore() {
        Set<Var> attrVarsMentioned = this.attrRelation.getVarsMentioned();
        Set<Var> filterVarsMentioned = this.filterRelation.getVarsMentioned();
        Map varMap = VarUtils.createJoinVarMap(attrVarsMentioned, filterVarsMentioned, this.attrJoinVars, this.filterJoinVars, null);
        Element filterElement = this.filterRelation.getElement();
        Element newFilterElement = ElementUtils.createRenamedElement((Element)filterElement, (Map)varMap);
        List<Var> newFilterVars = this.filterRelation.getVars().stream().map(v -> varMap.getOrDefault(v, v)).collect(Collectors.toList());
        FragmentImpl result = new FragmentImpl(newFilterElement, newFilterVars);
        return result;
    }

    public Fragment get() {
        List<Var> attrProjVars = this.varToOrigin == null ? this.attrRelation.getVars() : new ArrayList<Var>(this.varToOrigin.keySet());
        Set<Var> attrVarsMentioned = this.attrRelation.getVarsMentioned();
        Set<Var> filterVarsMentioned = this.filterRelation.getVarsMentioned();
        Set<Object> fixedVarsLhs = attrVarsMentioned;
        Set<Var> fixedVarsRhs = Collections.emptySet();
        if (this.varToOrigin != null) {
            fixedVarsLhs = this.varToOrigin.entrySet().stream().filter(e -> (Boolean)e.getValue()).map(Map.Entry::getKey).collect(Collectors.toSet());
            fixedVarsRhs = this.varToOrigin.entrySet().stream().filter(e -> (Boolean)e.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toSet());
        }
        HashSet<Var> conflictVars = new HashSet<Var>((Collection<Var>)Sets.intersection(attrVarsMentioned, filterVarsMentioned));
        HashMap<Var, Var> lhsMap = new HashMap<Var, Var>();
        HashMap<Var, Var> rhsMap = new HashMap<Var, Var>();
        for (int i = 0; i < this.attrJoinVars.size(); ++i) {
            Var sourceJoinVar = this.attrJoinVars.get(i);
            Var targetJoinVar = this.filterJoinVars.get(i);
            rhsMap.put(targetJoinVar, sourceJoinVar);
        }
        VarGeneratorBlacklist gen = VarGeneratorBlacklist.create((Collection)Sets.union(attrVarsMentioned, filterVarsMentioned));
        this.resolveConflicts(filterVarsMentioned, fixedVarsRhs, conflictVars, lhsMap, rhsMap, (Generator<Var>)gen);
        this.resolveConflicts(attrVarsMentioned, fixedVarsLhs, conflictVars, rhsMap, lhsMap, (Generator<Var>)gen);
        Element filterElement = this.filterRelation.getElement();
        Element newFilterElement = ElementUtils.createRenamedElement((Element)filterElement, rhsMap);
        Element attrElement = this.attrRelation.getElement();
        Element newAttrElement = ElementUtils.createRenamedElement((Element)attrElement, lhsMap);
        boolean allowOmitJoin = true;
        boolean canOmitJoin = false;
        if (allowOmitJoin) {
            if (this.filterRelation.getElements().isEmpty()) {
                canOmitJoin = true;
            } else if (this.filterRelation.getVars().size() == 1) {
                Fragment1 fr = this.filterRelation.toFragment1();
                Var rawFilterVar = fr.getVar();
                if (fr.isSubjectConcept()) {
                    List<Element> elts;
                    boolean requiresJoin = false;
                    if (this.filterRelationFirst && !(elts = this.attrRelation.getElements()).isEmpty()) {
                        requiresJoin = elts.get(0) instanceof ElementOptional;
                    }
                    if (!requiresJoin) {
                        Var effectiveFilterVar = (Var)rhsMap.get(rawFilterVar);
                        Op attrOp = Algebra.compile((Element)newAttrElement);
                        Tuple tuple = OpVars.mentionedVarsByPosition((Op)attrOp);
                        canOmitJoin = ((Set)tuple.get(1)).contains(effectiveFilterVar);
                    }
                }
            }
        }
        List fes = ElementUtils.toElementList((Element)newFilterElement);
        List aes = ElementUtils.toElementList((Element)newAttrElement);
        Element newElement = canOmitJoin ? newAttrElement : (this.filterRelationFirst ? ElementUtils.groupIfNeeded((Iterable)Iterables.concat((Iterable)fes, (Iterable)aes)) : ElementUtils.groupIfNeeded((Iterable)Iterables.concat((Iterable)aes, (Iterable)fes)));
        FragmentImpl result = new FragmentImpl(newElement, attrProjVars);
        return result;
    }

    public static <T> T pop(Iterable<T> items) {
        Iterator<T> it = items.iterator();
        T result = it.next();
        it.remove();
        return result;
    }

    public void resolveConflicts(Set<Var> rhsVarsMentioned, Set<Var> rhsFixedVars, Set<Var> conflictVars, Map<Var, Var> lhsMap, Map<Var, Var> rhsMap, Generator<Var> gen) {
        while (!conflictVars.isEmpty()) {
            Var rhsFreshVar;
            Var rhsJoinVar = FragmentJoiner.pop(conflictVars);
            if (rhsFixedVars.contains(rhsJoinVar)) continue;
            Set<Var> rhsJoinVars = rhsMap.keySet();
            Sets.SetView rhsNonJoinVars = Sets.difference(rhsVarsMentioned, rhsJoinVars);
            Var targetLhsVar = rhsMap.get(rhsJoinVar);
            if (targetLhsVar != null) {
                if (!rhsNonJoinVars.contains(targetLhsVar)) continue;
                rhsFreshVar = (Var)gen.next();
                conflictVars.remove(targetLhsVar);
                rhsMap.put(targetLhsVar, rhsFreshVar);
                continue;
            }
            rhsFreshVar = (Var)gen.next();
            rhsMap.put(rhsJoinVar, rhsFreshVar);
        }
    }
}

