/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.fragment.impl;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Set;
import org.aksw.jenax.sparql.fragment.impl.UnaryXExpr;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVars;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.ExprUtils;

public class UnaryXExprImpl
implements UnaryXExpr {
    protected Expr expr;
    protected Var var;
    protected Set<Var> varsMentioned;

    public UnaryXExprImpl(Expr expr, Var var) {
        this.expr = expr;
        this.var = var;
        this.varsMentioned = Collections.singleton(var);
    }

    @Override
    public Set<Var> getVarsMentioned() {
        return this.varsMentioned;
    }

    @Override
    public Var getVar() {
        return this.var;
    }

    @Override
    public Expr getExpr() {
        return this.expr;
    }

    public static UnaryXExpr create(Expr expr) {
        Set vars = ExprVars.getVarsMentioned((Expr)expr);
        if (vars.size() > 1) {
            throw new RuntimeException("too many variables in expr - got " + String.valueOf(vars));
        }
        Var var = (Var)Iterables.getFirst((Iterable)vars, null);
        UnaryXExprImpl result = new UnaryXExprImpl(expr, var);
        return result;
    }

    public static NodeValue eval(UnaryXExpr xexpr, Node value) {
        Var var = xexpr.getVar();
        Expr expr = xexpr.getExpr();
        Binding b = BindingFactory.binding((Var)var, (Node)value);
        NodeValue result = ExprUtils.eval((Expr)expr, (Binding)b);
        return result;
    }
}

