/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.fragment.api;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.jenax.arq.util.expr.ExprUtils;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.var.VarUtils;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.api.Fragment3;
import org.aksw.jenax.sparql.fragment.api.HasElement;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.aksw.jenax.sparql.fragment.impl.Fragment2Impl;
import org.aksw.jenax.sparql.fragment.impl.Fragment3Impl;
import org.aksw.jenax.sparql.fragment.impl.FragmentImpl;
import org.aksw.jenax.sparql.fragment.impl.FragmentJoiner;
import org.aksw.jenax.sparql.fragment.impl.FragmentUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;

public interface Fragment
extends HasElement {
    public List<Var> getVars();

    default public Set<Var> getNonDistinguishedVars() {
        Set<Var> mentionedVars = this.getVarsMentioned();
        HashSet<Var> markedVars = new HashSet<Var>(this.getVars());
        Sets.SetView result = Sets.difference(mentionedVars, markedVars);
        return result;
    }

    default public Fragment rename(Function<String, String> renameFn, Var ... constantVars) {
        HashSet<Var> constants = new HashSet<Var>(Arrays.asList(constantVars));
        Set<Var> vars = this.getVarsMentioned();
        Map<Var, Var> oldToNew = vars.stream().filter((? super T v) -> !constants.contains(v)).collect(Collectors.toMap(v -> v, v -> Var.alloc((String)((String)renameFn.apply(v.getName())))));
        Element newElement = ElementUtils.createRenamedElement((Element)this.getElement(), oldToNew);
        List<Var> newVars = this.getVars().stream().map(v -> oldToNew.getOrDefault(v, (Var)v)).collect(Collectors.toList());
        FragmentImpl result = new FragmentImpl(newElement, newVars);
        return result;
    }

    default public Fragment rename(List<Var> targetVars) {
        return FragmentUtils.rename(this, targetVars);
    }

    default public Fragment1 toFragment1() {
        List<Var> vars = this.getVars();
        if (vars.size() != 1) {
            throw new UnsupportedOperationException();
        }
        Element e = this.getElement();
        Concept result = new Concept(e, vars.get(0));
        return result;
    }

    default public Fragment2 toFragment2() {
        List<Var> vars = this.getVars();
        if (vars.size() != 2) {
            throw new UnsupportedOperationException();
        }
        Element e = this.getElement();
        Fragment2Impl result = new Fragment2Impl(e, vars.get(0), vars.get(1));
        return result;
    }

    default public Fragment3 toFragment3() {
        List<Var> vars = this.getVars();
        if (vars.size() != 3) {
            throw new UnsupportedOperationException();
        }
        Element e = this.getElement();
        Fragment3Impl result = new Fragment3Impl(e, vars.get(0), vars.get(1), vars.get(2));
        return result;
    }

    default public Set<Var> getVarsMentioned() {
        Element e = this.getElement();
        Set result = ElementUtils.getVarsMentioned((Element)e);
        List<Var> distinguishedVars = this.getVars();
        result.addAll(distinguishedVars);
        return result;
    }

    default public Fragment applyNodeTransform(NodeTransform nodeTransform) {
        return Fragment.applyDefaultNodeTransform(this, nodeTransform);
    }

    public static Fragment applyDefaultNodeTransform(Fragment r, NodeTransform nodeTransform) {
        List<Var> transformedVars = r.getVars().stream().map(v -> VarUtils.applyNodeTransform((Var)v, (NodeTransform)nodeTransform)).collect(Collectors.toList());
        Element transformedElement = ElementUtils.applyNodeTransform((Element)r.getElement(), (NodeTransform)nodeTransform);
        FragmentImpl result = new FragmentImpl(transformedElement, transformedVars);
        return result;
    }

    default public FragmentJoiner joinOn(List<Var> vars) {
        return new FragmentJoiner(this, vars);
    }

    default public FragmentJoiner joinOn(Var ... vars) {
        return FragmentJoiner.from(this, vars);
    }

    default public FragmentJoiner prependOn(Var ... vars) {
        return this.prependOn(Arrays.asList(vars)).filterRelationFirst(true);
    }

    default public FragmentJoiner prependOn(List<Var> vars) {
        return FragmentJoiner.from(this, vars).filterRelationFirst(true);
    }

    default public Fragment project(List<Var> vars) {
        return new FragmentImpl(this.getElement(), vars);
    }

    default public Fragment project(Var ... vars) {
        return this.project(Arrays.asList(vars));
    }

    default public Fragment filter(Var var, Node node) {
        return this.filter((Expr)new E_Equals(ExprLib.nodeToExpr((Node)var), ExprLib.nodeToExpr((Node)node)));
    }

    default public Fragment filter(Expr ... exprs) {
        return this.filter(Arrays.asList(exprs));
    }

    default public Fragment filter(Iterable<Expr> exprs) {
        Fragment result = !exprs.iterator().hasNext() ? this : this.filter(ExprUtils.andifyBalanced(exprs));
        return result;
    }

    default public Fragment filter(Expr expr) {
        ArrayList<Object> elts = new ArrayList<Object>();
        elts.addAll(this.getElements());
        elts.add(new ElementFilter(expr));
        Element newElt = ElementUtils.groupIfNeeded(elts);
        List<Var> vars = this.getVars();
        FragmentImpl result = new FragmentImpl(newElt, vars);
        return result;
    }

    default public Query toQuery() {
        Query result = FragmentUtils.createQuery(this);
        return result;
    }

    default public List<Element> getElements() {
        return ElementUtils.toElementList((Element)this.getElement());
    }
}

