/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.rdfterm;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfTerm
extends FunctionBase4 {
    private static final Logger logger = LoggerFactory.getLogger(RdfTerm.class);

    public static String toLexicalForm(NodeValue nodeValue) {
        return nodeValue.asUnquotedString();
    }

    public NodeValue exec(NodeValue type, NodeValue node, NodeValue langTag, NodeValue datatype) {
        return RdfTerm.eval(type, node, langTag, datatype);
    }

    public static NodeValue eval(NodeValue type, NodeValue node, NodeValue langTag, NodeValue datatype) {
        String lexicalForm = RdfTerm.toLexicalForm(node);
        int typeValue = type.getDecimal().intValue();
        switch (typeValue) {
            case 0: {
                NodeValue result = NodeValue.makeNode((Node)NodeFactory.createBlankNode((String)RdfTerm.toLexicalForm(node)));
                return result;
            }
            case 1: {
                return NodeValue.makeNode((Node)NodeFactory.createURI((String)RdfTerm.toLexicalForm(node)));
            }
            case 2: {
                String dt = RdfTerm.toLexicalForm(datatype);
                if (dt != null && !dt.isEmpty()) {
                    logger.warn("Language tag should be null or empty, was '" + dt + "'");
                }
                return NodeValue.makeNode((String)lexicalForm, (String)RdfTerm.toLexicalForm(langTag), null);
            }
            case 3: {
                String lang = RdfTerm.toLexicalForm(langTag);
                if (lang != null && !lang.isEmpty()) {
                    logger.warn("Language tag should be null or empty, was '" + lang + "'");
                }
                return NodeValue.makeNode((String)lexicalForm, null, (String)RdfTerm.toLexicalForm(datatype));
            }
        }
        throw new RuntimeException("Invalid type-value for RdfTerm: " + typeValue);
    }
}

