/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.rdfterm;

import java.util.List;
import java.util.Optional;
import org.aksw.jenax.arq.rdfterm.RdfTerm;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.expr.E_BNode;
import org.apache.jena.sparql.expr.E_StrDatatype;
import org.apache.jena.sparql.expr.E_StrLang;
import org.apache.jena.sparql.expr.E_URI;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprFunctionN;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.Symbol;

public class E_RdfTerm
extends ExprFunctionN {
    public static final String tagRdfTerm = "http://aksw.org/jena/rdfTerm";
    public static final NodeValue typeVar = NodeValue.makeInteger((long)-1L);
    public static final NodeValue typeBlank = NodeValue.makeInteger((long)0L);
    public static final NodeValue typeUri = NodeValue.makeInteger((long)1L);
    public static final NodeValue typePlainLiteral = NodeValue.makeInteger((long)2L);
    public static final NodeValue typeTypedLiteral = NodeValue.makeInteger((long)3L);

    public static E_RdfTerm createVar(ExprVar expr) {
        return new E_RdfTerm((Expr)typeVar, (Expr)expr, (Expr)NodeValue.nvEmptyString, (Expr)NodeValue.nvEmptyString);
    }

    public static E_RdfTerm createBlankNode(Expr expr) {
        return new E_RdfTerm((Expr)typeBlank, expr, (Expr)NodeValue.nvEmptyString, (Expr)NodeValue.nvEmptyString);
    }

    public static E_RdfTerm createUri(Expr expr) {
        return new E_RdfTerm((Expr)typeUri, expr, (Expr)NodeValue.nvEmptyString, (Expr)NodeValue.nvEmptyString);
    }

    public static E_RdfTerm createPlainLiteral(Expr expr) {
        return new E_RdfTerm((Expr)typePlainLiteral, expr, (Expr)NodeValue.nvEmptyString, (Expr)NodeValue.nvEmptyString);
    }

    public static E_RdfTerm createPlainLiteral(Expr expr, Expr langTag) {
        return new E_RdfTerm((Expr)typePlainLiteral, expr, langTag, (Expr)NodeValue.nvEmptyString);
    }

    public static E_RdfTerm createTypedLiteral(Expr expr, Expr datatype) {
        return new E_RdfTerm((Expr)typeTypedLiteral, expr, (Expr)NodeValue.nvEmptyString, datatype);
    }

    public static E_RdfTerm createTypedLiteral(Expr expr, Resource datatype) {
        return E_RdfTerm.createTypedLiteral(expr, datatype.asNode());
    }

    public static E_RdfTerm createTypedLiteral(Expr expr, Node datatype) {
        String datatypeUri = datatype.getURI();
        NodeValue datatypeExpr = NodeValue.makeString((String)datatypeUri);
        return new E_RdfTerm((Expr)typeTypedLiteral, expr, (Expr)NodeValue.nvEmptyString, (Expr)datatypeExpr);
    }

    public String getFunctionIRI() {
        return tagRdfTerm;
    }

    public E_RdfTerm(List<Expr> exprs) {
        this(exprs.get(0), exprs.get(1), exprs.get(2), exprs.get(3));
    }

    public E_RdfTerm(Expr type, Expr lexicalValue, Expr languageTag, Expr datatype) {
        super(tagRdfTerm, new Expr[]{type, lexicalValue, languageTag, datatype});
    }

    public Expr getType() {
        return (Expr)super.getArgs().get(0);
    }

    public Expr getLexicalValue() {
        return (Expr)super.getArgs().get(1);
    }

    public Expr getLanguageTag() {
        return (Expr)super.getArgs().get(2);
    }

    public Expr getDatatype() {
        return (Expr)super.getArgs().get(3);
    }

    public boolean isConstant() {
        return false;
    }

    public String getFunctionPrintName(SerializationContext cxt) {
        String functionIri = this.getFunctionIRI();
        Object result = functionIri == null ? super.getFunctionPrintName(cxt) : "<" + functionIri + ">";
        return result;
    }

    public NodeValue getConstant() {
        NodeValue result = RdfTerm.eval(((Expr)this.getArgs().get(0)).getConstant(), ((Expr)this.getArgs().get(1)).getConstant(), ((Expr)this.getArgs().get(2)).getConstant(), ((Expr)this.getArgs().get(3)).getConstant());
        return result;
    }

    public NodeValue eval(List<NodeValue> args) {
        return RdfTerm.eval(args.get(0), args.get(1), args.get(2), args.get(3));
    }

    public Expr copy(ExprList args) {
        return new E_RdfTerm(args.get(0), args.get(1), args.get(2), args.get(3));
    }

    public static E_RdfTerm expand(Expr expr) {
        E_RdfTerm result;
        if (expr.isFunction()) {
            ExprFunction fn = expr.getFunction();
            result = E_RdfTerm.expand(fn);
        } else {
            result = null;
        }
        return result;
    }

    public static E_RdfTerm expand(ExprFunction fn) {
        String symbol = Optional.ofNullable(fn.getFunctionSymbol()).map(Symbol::getSymbol).orElse(null);
        E_RdfTerm result = "uri".equals(symbol) || "iri".equals(symbol) ? E_RdfTerm.createUri(fn.getArg(1)) : ("strlang".equals(symbol) ? E_RdfTerm.createPlainLiteral(fn.getArg(1), fn.getArg(2)) : ("strdt".equals(symbol) ? E_RdfTerm.createTypedLiteral(fn.getArg(1), fn.getArg(2)) : ("bnode".equals(symbol) ? E_RdfTerm.createBlankNode(fn.getArg(1)) : (tagRdfTerm.equals(symbol) ? new E_RdfTerm(fn.getArg(1), fn.getArg(2), fn.getArg(3), fn.getArg(4)) : null))));
        return result;
    }

    public static ExprFunction normalize(E_RdfTerm rdfTerm) {
        int termTypeId = rdfTerm.getType().getConstant().getDecimal().intValue();
        return switch (termTypeId) {
            case 0 -> (ExprFunction)E_BNode.create((Expr)rdfTerm.getLexicalValue());
            case 1 -> new E_URI(rdfTerm.getLexicalValue());
            case 2 -> new E_StrLang(rdfTerm.getLexicalValue(), rdfTerm.getLanguageTag());
            case 3 -> new E_StrDatatype(rdfTerm.getLexicalValue(), rdfTerm.getDatatype());
            default -> throw new RuntimeException("Unsupported term type: " + String.valueOf((Object)rdfTerm));
        };
    }
}

