/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.dataset.impl;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.aksw.jenax.arq.dataset.api.LiteralInDataset;
import org.aksw.jenax.arq.dataset.api.ResourceInDataset;
import org.aksw.jenax.arq.util.node.NodeTransformLib2;
import org.aksw.jenax.arq.util.quad.DatasetUtils;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.util.ResourceUtils;
import org.apache.jena.vocabulary.RDFS;

public class ResourceInDatasetImpl
extends ResourceImpl
implements ResourceInDataset {
    protected Dataset dataset;
    protected String graphName;

    public static void main(String[] args) {
        Dataset ds = DatasetFactory.create();
        System.out.println("Reference equality of result of multiple .getDefaultModel() invocations: " + (ds.getDefaultModel() == ds.getDefaultModel()));
        System.out.println("State equality of result of multiple .getDefaultModel() invocations: " + ds.getDefaultModel().equals((Object)ds.getDefaultModel()));
        Resource r1 = ds.getDefaultModel().createResource();
        Resource r2 = ds.getDefaultModel().createResource("urn:x-test:foo");
        System.out.println("Reference equality models of the same graph: " + (r1.getModel() == r2.getModel()));
        System.out.println("State equality models of the same graph: " + r1.getModel().equals((Object)r2.getModel()));
        r1.addProperty(RDFS.label, "r1");
        r2.addProperty(RDFS.label, "r2");
        System.out.println("Counts should be equal: " + r1.getModel().size() + " " + r2.getModel().size());
        ResourceInDataset x1 = ResourceInDatasetImpl.createFromCopyIntoDefaultGraph(r1);
        RDFDataMgr.write((OutputStream)System.out, (Dataset)x1.getDataset(), (RDFFormat)RDFFormat.TRIG_PRETTY);
        ResourceInDataset x2 = ResourceInDatasetImpl.createFromCopyIntoResourceGraph(r2);
        RDFDataMgr.write((OutputStream)System.out, (Dataset)x2.getDataset(), (RDFFormat)RDFFormat.TRIG_PRETTY);
    }

    public static List<ResourceInDataset> selectByProperty(Dataset dataset, Property p) {
        Iterator it = dataset.asDatasetGraph().find(Node.ANY, Node.ANY, p.asNode(), Node.ANY);
        ArrayList<ResourceInDataset> result = new ArrayList<ResourceInDataset>();
        while (it.hasNext()) {
            Quad q = (Quad)it.next();
            String graphName = q.getGraph().getURI();
            ResourceInDatasetImpl tmp = new ResourceInDatasetImpl(dataset, graphName, q.getSubject());
            result.add(tmp);
        }
        return result;
    }

    public static ResourceInDataset applyNodeTransform(ResourceInDataset old, NodeTransform nodeTransform) {
        String graphName = old.getGraphName();
        Node graphNode = NodeFactory.createURI((String)graphName);
        Node newGraphNode = Optional.ofNullable((Node)nodeTransform.apply((Object)graphNode)).orElse(graphNode);
        Node n = old.asNode();
        Node newNode = Optional.ofNullable((Node)nodeTransform.apply((Object)n)).orElse(n);
        String g = newGraphNode.getURI();
        Dataset dataset = old.getDataset();
        NodeTransformLib2.applyNodeTransform((NodeTransform)nodeTransform, (Dataset)dataset);
        ResourceInDatasetImpl result = new ResourceInDatasetImpl(dataset, g, newNode);
        return result;
    }

    public static ResourceInDataset renameResource(ResourceInDataset old, String uri) {
        Dataset dataset = old.getDataset();
        String graphName = old.getGraphName();
        Resource n = ResourceUtils.renameResource((Resource)old, (String)uri);
        Node newNode = n.asNode();
        ResourceInDatasetImpl result = new ResourceInDatasetImpl(dataset, graphName, newNode);
        return result;
    }

    public static ResourceInDataset renameGraph(ResourceInDataset r, String tgtGraphName) {
        ResourceInDataset result;
        Dataset ds = r.getDataset();
        String srcGraphName = r.getGraphName();
        if (!Objects.equals(srcGraphName, tgtGraphName)) {
            Model srcModel = DatasetUtils.getDefaultOrNamedModel((Dataset)ds, (String)srcGraphName);
            Model srcCopy = ModelFactory.createDefaultModel();
            srcCopy.add(srcModel);
            srcModel.removeAll();
            Model tgtModel = DatasetUtils.getDefaultOrNamedModel((Dataset)ds, (String)tgtGraphName);
            tgtModel.add(srcCopy);
            Node node = r.asNode();
            result = new ResourceInDatasetImpl(ds, tgtGraphName, node);
        } else {
            result = r;
        }
        return result;
    }

    public static ResourceInDataset createAnonInDefaultGraph() {
        Dataset ds = DatasetFactory.create();
        Node root = NodeFactory.createBlankNode();
        ResourceInDatasetImpl result = new ResourceInDatasetImpl(ds, Quad.defaultGraphIRI.getURI(), root);
        return result;
    }

    public static ResourceInDataset createFromCopyIntoDefaultGraph(Resource r) {
        ResourceInDataset result = ResourceInDatasetImpl.createFromCopy(DatasetFactory.create(), Quad.defaultGraphIRI.getURI(), r);
        return result;
    }

    public static ResourceInDataset createInDefaultGraph(Node node) {
        Dataset dataset = DatasetFactory.create();
        ResourceInDatasetImpl result = new ResourceInDatasetImpl(dataset, Quad.defaultGraphIRI.getURI(), node);
        return result;
    }

    public static ResourceInDataset createFromCopyIntoResourceGraph(Resource r) {
        ResourceInDataset result = ResourceInDatasetImpl.createFromCopy(DatasetFactory.create(), r.getURI(), r);
        return result;
    }

    public static ResourceInDataset createFromCopy(Dataset tgt, String graphName, Resource src) {
        Model m = DatasetUtils.getDefaultOrNamedModel((Dataset)tgt, (String)graphName);
        GraphUtil.addInto((Graph)m.getGraph(), (Graph)src.getModel().getGraph());
        Map prefixes = src.getModel().getNsPrefixMap();
        m.setNsPrefixes(prefixes);
        tgt.getDefaultModel().setNsPrefixes(prefixes);
        Node root = src.asNode();
        ResourceInDatasetImpl result = new ResourceInDatasetImpl(tgt, graphName, root);
        return result;
    }

    public ResourceInDatasetImpl(Dataset dataset, String graphName, Node node) {
        super(node, (EnhGraph)DatasetUtils.getDefaultOrNamedModel((Dataset)dataset, (String)graphName));
        this.dataset = dataset;
        this.graphName = graphName;
    }

    @Override
    public String getGraphName() {
        return this.graphName;
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public ResourceInDatasetImpl asResource() {
        return this;
    }

    @Override
    public ResourceInDataset inDataset(Dataset other) {
        return new ResourceInDatasetImpl(other, this.graphName, this.node);
    }

    @Override
    public LiteralInDataset asLiteral() {
        super.asLiteral();
        return null;
    }
}

