/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.dataset.impl;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.aksw.jenax.arq.dataset.api.RDFNodeInDataset;
import org.aksw.jenax.arq.dataset.api.ResourceInDataset;
import org.aksw.jenax.arq.dataset.impl.ResourceInDatasetImpl;
import org.aksw.jenax.arq.util.quad.DatasetUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelGraphInterface;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class RDFNodeInDatasetUtils {
    public RDFNodeInDataset asRDFNodeInDataset(RDFNode rdfNode) {
        RDFNodeInDataset result;
        Model model = rdfNode.getModel();
        Graph graph = Optional.ofNullable(model).map(ModelGraphInterface::getGraph).orElse(null);
        if (graph instanceof GraphView) {
            GraphView gv = (GraphView)graph;
            Node graphNode = gv.getGraphName();
            DatasetGraph dg = gv.getDataset();
            result = RDFNodeInDataset.create(DatasetFactory.wrap((DatasetGraph)dg), graphNode.getURI(), rdfNode.asNode());
        } else {
            result = RDFNodeInDataset.create(DatasetFactory.wrap((Model)model), Quad.defaultGraphIRI.getURI(), rdfNode.asNode());
        }
        return result;
    }

    public static ExtendedIterator<ResourceInDataset> listResourcesWithProperty(Dataset dataset, Property p) {
        Iterator it = Iterators.concat(Collections.singleton(Quad.defaultGraphIRI.getURI()).iterator(), (Iterator)dataset.listNames());
        ArrayList graphNames = Lists.newArrayList((Iterator)it);
        List list = graphNames.stream().flatMap(graphName -> {
            Model model = DatasetUtils.getDefaultOrNamedModel((Dataset)dataset, (String)graphName);
            List rs = model.listResourcesWithProperty(p).mapWith(r -> new ResourceInDatasetImpl(dataset, (String)graphName, r.asNode())).toList();
            return rs.stream();
        }).collect(Collectors.toList());
        return WrappedIterator.create(list.iterator());
    }
}

