/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.dataset.api;

import java.util.function.Consumer;
import org.aksw.jenax.arq.dataset.api.LiteralInDataset;
import org.aksw.jenax.arq.dataset.api.ResourceInDataset;
import org.aksw.jenax.arq.dataset.impl.LiteralInDatasetImpl;
import org.aksw.jenax.arq.dataset.impl.ResourceInDatasetImpl;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.RDFNode;

public interface RDFNodeInDataset
extends RDFNode {
    public String getGraphName();

    public Dataset getDataset();

    public RDFNodeInDataset inDataset(Dataset var1);

    public LiteralInDataset asLiteral();

    public ResourceInDataset asResource();

    default public RDFNodeInDataset mutateRDFNode(Consumer<? super RDFNode> resourceMutator) {
        resourceMutator.accept(this);
        return this;
    }

    default public RDFNodeInDataset asRDFNodeInDatasetHere(Node node) {
        Dataset ds = this.getDataset();
        String gn = this.getGraphName();
        return RDFNodeInDataset.create(ds, gn, node);
    }

    public static RDFNodeInDataset create(Dataset dataset, String graphName, Node node) {
        RDFNodeInDataset result;
        if (node.isBlank() || node.isURI()) {
            result = new ResourceInDatasetImpl(dataset, graphName, node);
        } else if (node.isLiteral()) {
            result = new LiteralInDatasetImpl(dataset, graphName, node);
        } else {
            throw new IllegalArgumentException("Unsupported node type: " + String.valueOf(node));
        }
        return result;
    }
}

