/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.dataset.impl;

import java.util.Optional;
import org.aksw.jenax.arq.dataset.api.ResourceInDataset;
import org.aksw.jenax.arq.dataset.impl.ResourceInDatasetImpl;
import org.aksw.jenax.arq.util.node.NodeTransformLib2;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.sparql.graph.NodeTransform;

public class ResourceInDatasetNodeTransformLib {
    public static ResourceInDataset applyNodeTransform(ResourceInDataset old, NodeTransform nodeTransform) {
        String graphName = old.getGraphName();
        Node graphNode = NodeFactory.createURI((String)graphName);
        Node newGraphNode = Optional.ofNullable((Node)nodeTransform.apply((Object)graphNode)).orElse(graphNode);
        Node n = old.asNode();
        Node newNode = Optional.ofNullable((Node)nodeTransform.apply((Object)n)).orElse(n);
        String g = newGraphNode.getURI();
        Dataset dataset = old.getDataset();
        NodeTransformLib2.applyNodeTransform((NodeTransform)nodeTransform, (Dataset)dataset);
        ResourceInDatasetImpl result = new ResourceInDatasetImpl(dataset, g, newNode);
        return result;
    }

    public static ResourceInDataset copyWithNodeTransform(ResourceInDataset old, Dataset target, NodeTransform nodeTransform) {
        String graphName = old.getGraphName();
        Node graphNode = NodeFactory.createURI((String)graphName);
        Node newGraphNode = Optional.ofNullable((Node)nodeTransform.apply((Object)graphNode)).orElse(graphNode);
        String g = newGraphNode.getURI();
        Node n = old.asNode();
        Node newNode = Optional.ofNullable((Node)nodeTransform.apply((Object)n)).orElse(n);
        NodeTransformLib2.copyWithNodeTransform((NodeTransform)nodeTransform, (Dataset)old.getDataset(), (Dataset)target);
        ResourceInDatasetImpl result = new ResourceInDatasetImpl(target, g, newNode);
        return result;
    }
}

