/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.engine.quad;

import java.util.Iterator;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIter;
import org.apache.jena.sparql.engine.iterator.QueryIterRepeatApply;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.util.iterator.ClosableIterator;
import org.apache.jena.util.iterator.NiceIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class QueryIterQuadPattern
extends QueryIterRepeatApply {
    private final Quad pattern;
    static int countMapper = 0;

    public QueryIterQuadPattern(QueryIterator input, Quad pattern, ExecutionContext cxt) {
        super(input, cxt);
        this.pattern = pattern;
    }

    protected QueryIterator nextStage(Binding binding) {
        return new QuadMapper(binding, this.pattern, this.getExecContext());
    }

    protected void details(IndentedWriter out, SerializationContext sCxt) {
        out.print("QueryIterTriplePattern: " + String.valueOf(this.pattern));
    }

    static class QuadMapper
    extends QueryIter {
        private Node g;
        private Node s;
        private Node p;
        private Node o;
        private Binding binding;
        private ClosableIterator<Quad> graphIter;
        private Binding slot = null;
        private boolean finished = false;
        private volatile boolean cancelled = false;

        QuadMapper(Binding binding, Quad pattern, ExecutionContext cxt) {
            super(cxt);
            this.g = QuadMapper.substitute(pattern.getGraph(), binding);
            this.s = QuadMapper.substitute(pattern.getSubject(), binding);
            this.p = QuadMapper.substitute(pattern.getPredicate(), binding);
            this.o = QuadMapper.substitute(pattern.getObject(), binding);
            this.binding = binding;
            Node g2 = QuadMapper.tripleNode(this.g);
            Node s2 = QuadMapper.tripleNode(this.s);
            Node p2 = QuadMapper.tripleNode(this.p);
            Node o2 = QuadMapper.tripleNode(this.o);
            DatasetGraph dg = cxt.getDataset();
            this.graphIter = QuadMapper.makeClosable(dg.find(g2, s2, p2, o2));
        }

        private static <T> ClosableIterator<T> makeClosable(Iterator<T> it) {
            Object result = it instanceof ClosableIterator ? (ClosableIterator)it : WrappedIterator.create(it);
            return result;
        }

        private static Node tripleNode(Node node) {
            if (node.isVariable()) {
                return Node.ANY;
            }
            return node;
        }

        private static Node substitute(Node node, Binding binding) {
            Node x;
            if (Var.isVar((Node)node) && (x = binding.get(Var.alloc((Node)node))) != null) {
                return x;
            }
            return node;
        }

        private Binding mapper(Quad r) {
            BindingBuilder results = BindingFactory.builder((Binding)this.binding);
            if (!QuadMapper.insert(this.g, r.getGraph(), results)) {
                return null;
            }
            if (!QuadMapper.insert(this.s, r.getSubject(), results)) {
                return null;
            }
            if (!QuadMapper.insert(this.p, r.getPredicate(), results)) {
                return null;
            }
            if (!QuadMapper.insert(this.o, r.getObject(), results)) {
                return null;
            }
            return results.build();
        }

        private static boolean insert(Node inputNode, Node outputNode, BindingBuilder results) {
            if (!Var.isVar((Node)inputNode)) {
                return true;
            }
            Var v = Var.alloc((Node)inputNode);
            Node x = results.get(v);
            if (x != null) {
                return outputNode.equals((Object)x);
            }
            results.add(v, outputNode);
            return true;
        }

        protected boolean hasNextBinding() {
            if (this.finished) {
                return false;
            }
            if (this.slot != null) {
                return true;
            }
            if (this.cancelled) {
                this.graphIter.close();
                this.finished = true;
                return false;
            }
            while (this.graphIter.hasNext() && this.slot == null) {
                Quad t = (Quad)this.graphIter.next();
                this.slot = this.mapper(t);
            }
            if (this.slot == null) {
                this.finished = true;
            }
            return this.slot != null;
        }

        protected Binding moveToNextBinding() {
            if (!this.hasNextBinding()) {
                throw new ARQInternalErrorException();
            }
            Binding r = this.slot;
            this.slot = null;
            return r;
        }

        protected void closeIterator() {
            if (this.graphIter != null) {
                NiceIterator.close(this.graphIter);
            }
            this.graphIter = null;
        }

        protected void requestCancel() {
            this.cancelled = true;
        }
    }
}

