/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.engine.quad.assembler;

import java.util.Objects;
import org.aksw.jenax.arq.engine.quad.assembler.RdfDatasetAssemblerQuads;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.DatasetAssembler;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.engine.main.QueryEngineMainQuad;
import org.apache.jena.sparql.engine.main.solver.OpExecutorQuads;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetAssemblerQuads
extends DatasetAssembler {
    private static final Logger logger = LoggerFactory.getLogger(DatasetAssemblerQuads.class);

    public DatasetGraph createDataset(Assembler a, Resource root) {
        RdfDatasetAssemblerQuads res = (RdfDatasetAssemblerQuads)root.as(RdfDatasetAssemblerQuads.class);
        Resource baseDatasetRes = res.getDataset();
        Objects.requireNonNull(baseDatasetRes, "No ja:bataset specified on " + String.valueOf(root));
        Object obj = a.open(baseDatasetRes);
        if (!(obj instanceof Dataset)) {
            Class<?> cls = obj == null ? null : obj.getClass();
            throw new AssemblerException(root, "Expected ja:baseDataset to be a Dataset but instead got " + Objects.toString(cls));
        }
        logger.info("Configuring quad engine on dataset with id " + String.valueOf(baseDatasetRes.asNode()));
        Dataset dataset = (Dataset)obj;
        Context cxt = dataset.getContext();
        QC.setFactory((Context)cxt, OpExecutorQuads::new);
        QueryEngineRegistry reg = new QueryEngineRegistry();
        reg.add(QueryEngineMainQuad.getFactory());
        QueryEngineRegistry.set((Context)cxt, (QueryEngineRegistry)reg);
        DatasetGraph result = dataset.asDatasetGraph();
        return result;
    }
}

