/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.path;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.aksw.jenax.sparql.path.PathTransform;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.path.P_Alt;
import org.apache.jena.sparql.path.P_Distinct;
import org.apache.jena.sparql.path.P_FixedLength;
import org.apache.jena.sparql.path.P_Inverse;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Mod;
import org.apache.jena.sparql.path.P_Multi;
import org.apache.jena.sparql.path.P_NegPropSet;
import org.apache.jena.sparql.path.P_OneOrMore1;
import org.apache.jena.sparql.path.P_OneOrMoreN;
import org.apache.jena.sparql.path.P_ReverseLink;
import org.apache.jena.sparql.path.P_Seq;
import org.apache.jena.sparql.path.P_Shortest;
import org.apache.jena.sparql.path.P_ZeroOrMore1;
import org.apache.jena.sparql.path.P_ZeroOrMoreN;
import org.apache.jena.sparql.path.P_ZeroOrOne;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathVisitor;

public class PathVisitorApplyTransform
implements PathVisitor {
    protected PathTransform pathTransform;
    protected NodeTransform nodeTransform;
    protected Deque<Path> stack = new ArrayDeque<Path>();

    public PathVisitorApplyTransform(PathTransform pathTransform, NodeTransform nodeTransform) {
        this.pathTransform = pathTransform;
        this.nodeTransform = nodeTransform;
    }

    public Path getResult() {
        if (this.stack.size() != 1) {
            throw new RuntimeException("Stack not aligned");
        }
        Path result = this.stack.pop();
        return result;
    }

    public Node applyNodeTransform(Node node) {
        Node result = this.nodeTransform == null ? node : (Node)this.nodeTransform.apply((Object)node);
        return result;
    }

    public void visit(P_Link path) {
        Node newNode = this.applyNodeTransform(path.getNode());
        Path newPath = this.pathTransform.transform(path, newNode);
        this.stack.push(newPath);
    }

    public void visit(P_ReverseLink path) {
        Node newNode = this.applyNodeTransform(path.getNode());
        Path newPath = this.pathTransform.transform(path, newNode);
        this.stack.push(newPath);
    }

    public void visit(P_NegPropSet path) {
        List newFwdNodes = path.getFwdNodes();
        List newBwdNodes = path.getBwdNodes();
        Path newPath = this.pathTransform.transform(path, newFwdNodes, newBwdNodes);
        this.stack.push(newPath);
    }

    public void visit(P_Inverse path) {
        Path subPath = this.stack.pop();
        Path newPath = this.pathTransform.transform(path, subPath);
        this.stack.push(newPath);
    }

    public void visit(P_Mod path) {
        Path subPath = this.stack.pop();
        Path newPath = this.pathTransform.transform(path, subPath, path.getMin(), path.getMax());
        this.stack.push(newPath);
    }

    public void visit(P_FixedLength path) {
        Path subPath = this.stack.pop();
        Path newPath = this.pathTransform.transform(path, subPath, path.getCount());
        this.stack.push(newPath);
    }

    public void visit(P_Distinct path) {
        Path subPath = this.stack.pop();
        Path newPath = this.pathTransform.transform(path, subPath);
        this.stack.push(newPath);
    }

    public void visit(P_Multi path) {
        Path subPath = this.stack.pop();
        Path newPath = this.pathTransform.transform(path, subPath);
        this.stack.push(newPath);
    }

    public void visit(P_Shortest path) {
        Path subPath = this.stack.pop();
        Path newPath = this.pathTransform.transform(path, subPath);
        this.stack.push(newPath);
    }

    public void visit(P_ZeroOrOne path) {
        Path subPath = this.stack.pop();
        Path newPath = this.pathTransform.transform(path, subPath);
        this.stack.push(newPath);
    }

    public void visit(P_ZeroOrMore1 path) {
        Path subPath = this.stack.pop();
        Path newPath = this.pathTransform.transform(path, subPath);
        this.stack.push(newPath);
    }

    public void visit(P_ZeroOrMoreN path) {
        Path subPath = this.stack.pop();
        Path newPath = this.pathTransform.transform(path, subPath);
        this.stack.push(newPath);
    }

    public void visit(P_OneOrMore1 path) {
        Path subPath = this.stack.pop();
        Path newPath = this.pathTransform.transform(path, subPath);
        this.stack.push(newPath);
    }

    public void visit(P_OneOrMoreN path) {
        Path subPath = this.stack.pop();
        Path newPath = this.pathTransform.transform(path, subPath);
        this.stack.push(newPath);
    }

    public void visit(P_Alt path) {
        Path newRight = this.stack.pop();
        Path newLeft = this.stack.pop();
        Path newPath = this.pathTransform.transform(path, newLeft, newRight);
        this.stack.push(newPath);
    }

    public void visit(P_Seq path) {
        Path newRight = this.stack.pop();
        Path newLeft = this.stack.pop();
        Path newPath = this.pathTransform.transform(path, newLeft, newRight);
        this.stack.push(newPath);
    }
}

