/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.path;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.commons.collections.IterableUtils;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.jenax.sparql.path.PathUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.path.P_Seq;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathWriter;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;

@Deprecated
public class SimplePath
implements Comparable<SimplePath> {
    private List<P_Path0> steps;

    public SimplePath() {
        this(new ArrayList<P_Path0>());
    }

    public SimplePath(List<P_Path0> steps) {
        this.steps = steps;
    }

    public List<P_Path0> getSteps() {
        return this.steps;
    }

    public static Map.Entry<SimplePath, P_Path0> seperateLastStep(SimplePath path) {
        List<P_Path0> steps = path.getSteps();
        int n = steps.size();
        Map.Entry result = Maps.immutableEntry((Object)new SimplePath(steps.subList(0, Math.max(0, n - 1))), steps.isEmpty() ? null : steps.get(n - 1));
        return result;
    }

    public static SimplePath fromPropertyPath(Path path) {
        List<P_Path0> steps = PathUtils.toList(path);
        return new SimplePath(steps);
    }

    public static Path toPropertyPath(SimplePath path) {
        return SimplePath.toPropertyPath(path.getSteps());
    }

    public static Path toPropertyPath(List<P_Path0> steps) {
        P_Path0 result = null;
        for (int i = 0; i < steps.size(); ++i) {
            P_Path0 contrib = steps.get(i);
            result = result == null ? contrib : new P_Seq((Path)result, (Path)contrib);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.steps == null ? 0 : this.steps.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimplePath other = (SimplePath)obj;
        return !(this.steps == null ? other.steps != null : !this.steps.equals(other.steps));
    }

    public String toString() {
        String str = this.steps == null || this.steps.isEmpty() ? "" : PathWriter.asString((Path)SimplePath.toPropertyPath(this), (Prologue)new Prologue(PrefixMapping.Extended));
        str = str.replaceAll("\\^(\r|\n)+", "^");
        return str;
    }

    public boolean isEmpty() {
        return this.steps.isEmpty();
    }

    public P_Path0 lastStep() {
        return this.steps.isEmpty() ? null : this.steps.get(this.steps.size() - 1);
    }

    public SimplePath parentPath() {
        SimplePath result = this.steps.isEmpty() ? null : new SimplePath(this.steps.subList(0, this.steps.size() - 1));
        return result;
    }

    public static List<Element> pathToElements(SimplePath path, Var start, Var end, Generator generator) {
        ArrayList<Element> result = new ArrayList<Element>();
        ElementTriplesBlock tmp = new ElementTriplesBlock();
        List<Triple> triples = SimplePath.pathToTriples(path, start, end, (Generator<Var>)generator);
        if (!triples.isEmpty()) {
            for (Triple triple : triples) {
                tmp.addTriple(triple);
            }
            result.add((Element)tmp);
        }
        return result;
    }

    public static List<Triple> pathToTriples(SimplePath path, Var start, Var end, Generator<Var> generator) {
        ArrayList<Triple> result = new ArrayList<Triple>();
        Var a = start;
        Iterator<P_Path0> it = path.getSteps().iterator();
        while (it.hasNext()) {
            P_Path0 step = it.next();
            Var b = it.hasNext() ? (Var)generator.next() : end;
            Triple t = step.isForward() ? Triple.create((Node)a, (Node)step.getNode(), (Node)b) : Triple.create((Node)b, (Node)step.getNode(), (Node)a);
            result.add(t);
            a = b;
        }
        return result;
    }

    public String toPathString() {
        String result = Joiner.on((char)' ').join(this.steps);
        return result;
    }

    @Override
    public int compareTo(SimplePath o) {
        int result = IterableUtils.compareByLengthThenItems(this.steps, o.steps, PathUtils::compareStep);
        return result;
    }

    public static Set<Node> mentionedNodes(SimplePath sp) {
        Set<Node> result = sp.getSteps().stream().map(P_Path0::getNode).collect(Collectors.toSet());
        return result;
    }
}

