/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.path;

import org.aksw.jenax.sparql.path.PathRewriter;
import org.aksw.jenax.sparql.path.PathRewriterVisitor;
import org.aksw.jenax.sparql.path.PathVisitorRewrite;
import org.apache.jena.sparql.path.P_Alt;
import org.apache.jena.sparql.path.P_Distinct;
import org.apache.jena.sparql.path.P_FixedLength;
import org.apache.jena.sparql.path.P_Inverse;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Mod;
import org.apache.jena.sparql.path.P_Multi;
import org.apache.jena.sparql.path.P_NegPropSet;
import org.apache.jena.sparql.path.P_OneOrMore1;
import org.apache.jena.sparql.path.P_OneOrMoreN;
import org.apache.jena.sparql.path.P_ReverseLink;
import org.apache.jena.sparql.path.P_Seq;
import org.apache.jena.sparql.path.P_Shortest;
import org.apache.jena.sparql.path.P_ZeroOrMore1;
import org.apache.jena.sparql.path.P_ZeroOrMoreN;
import org.apache.jena.sparql.path.P_ZeroOrOne;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathVisitor;

public class PathVisitorTopDown
implements PathVisitorRewrite {
    protected PathRewriter immediatePathRewriter;
    protected Path result = null;

    public PathVisitorTopDown(PathRewriter immediatePathRewriter) {
        this.immediatePathRewriter = immediatePathRewriter;
    }

    @Override
    public Path getResult() {
        return this.result;
    }

    public Path apply(Path path) {
        Path result = PathVisitorTopDown.apply(path, this.immediatePathRewriter);
        return result;
    }

    public static Path apply(Path path, PathVisitorRewrite visitor) {
        PathRewriterVisitor rewriter = new PathRewriterVisitor(visitor);
        Path result = PathVisitorTopDown.apply(path, rewriter);
        return result;
    }

    public static Path apply(Path path, PathRewriter immediatePathRewriter) {
        Path newPath = immediatePathRewriter.apply(path);
        PathVisitorTopDown descend = new PathVisitorTopDown(immediatePathRewriter);
        newPath.visit((PathVisitor)descend);
        Path result = descend.getResult();
        return result;
    }

    public void visit(P_Link path) {
        this.result = path;
    }

    public void visit(P_ReverseLink path) {
        this.result = path;
    }

    public void visit(P_NegPropSet path) {
        this.result = path;
    }

    public void visit(P_Inverse path) {
        Path newSubPath = this.apply(path.getSubPath());
        this.result = path.getSubPath() == newSubPath ? path : new P_Inverse(newSubPath);
    }

    public void visit(P_Mod path) {
        Path newSubPath = this.apply(path.getSubPath());
        this.result = path.getSubPath() == newSubPath ? path : new P_Mod(newSubPath, path.getMin(), path.getMax());
    }

    public void visit(P_FixedLength path) {
        Path newSubPath = this.apply(path.getSubPath());
        this.result = path.getSubPath() == newSubPath ? path : new P_FixedLength(newSubPath, path.getCount());
    }

    public void visit(P_Distinct path) {
        Path newSubPath = this.apply(path.getSubPath());
        this.result = path.getSubPath() == newSubPath ? path : new P_Distinct(newSubPath);
    }

    public void visit(P_Multi path) {
        Path newSubPath = this.apply(path.getSubPath());
        this.result = path.getSubPath() == newSubPath ? path : new P_Multi(newSubPath);
    }

    public void visit(P_Shortest path) {
        Path newSubPath = this.apply(path.getSubPath());
        this.result = path.getSubPath() == newSubPath ? path : new P_Shortest(newSubPath);
    }

    public void visit(P_ZeroOrOne path) {
        Path newSubPath = this.apply(path.getSubPath());
        this.result = path.getSubPath() == newSubPath ? path : new P_ZeroOrOne(newSubPath);
    }

    public void visit(P_ZeroOrMore1 path) {
        Path newSubPath = this.apply(path.getSubPath());
        this.result = path.getSubPath() == newSubPath ? path : new P_ZeroOrMore1(newSubPath);
    }

    public void visit(P_ZeroOrMoreN path) {
        Path newSubPath = this.apply(path.getSubPath());
        this.result = path.getSubPath() == newSubPath ? path : new P_ZeroOrMoreN(newSubPath);
    }

    public void visit(P_OneOrMore1 path) {
        Path newSubPath = this.apply(path.getSubPath());
        this.result = path.getSubPath() == newSubPath ? path : new P_OneOrMore1(newSubPath);
    }

    public void visit(P_OneOrMoreN path) {
        Path newSubPath = this.apply(path.getSubPath());
        this.result = path.getSubPath() == newSubPath ? path : new P_OneOrMoreN(newSubPath);
    }

    public void visit(P_Alt path) {
        Path newLeft = this.apply(path.getLeft());
        Path newRight = this.apply(path.getRight());
        this.result = path.getLeft() == newLeft && path.getRight() == newRight ? path : new P_Alt(newLeft, newRight);
    }

    public void visit(P_Seq path) {
        Path newLeft = this.apply(path.getLeft());
        Path newRight = this.apply(path.getRight());
        this.result = path.getLeft() == newLeft && path.getRight() == newRight ? path : new P_Seq(newLeft, newRight);
    }
}

