/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.path;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Set;
import org.aksw.jenax.arq.util.expr.ExprUtils;
import org.aksw.jenax.arq.util.node.NodeTransformCollectNodes;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.aksw.jenax.sparql.path.PathTransformCanonicalizeReverseLinks;
import org.aksw.jenax.sparql.path.PathTransformer;
import org.aksw.jenax.sparql.path.PathTransformerNullFold;
import org.aksw.jenax.sparql.path.PathVisitorToList;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.path.P_ReverseLink;
import org.apache.jena.sparql.path.P_Seq;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathFactory;
import org.apache.jena.sparql.path.PathVisitor;
import org.apache.jena.sparql.util.NodeCmp;

public class PathUtils {
    public static final Path nullPath = new P_Link(NodeUtils.nullUriNode);

    public static Set<Node> collectNodes(Path path) {
        NodeTransformCollectNodes nodeTransform = new NodeTransformCollectNodes();
        PathTransformer.transform(path, (NodeTransform)nodeTransform);
        Set result = nodeTransform.getNodes();
        return result;
    }

    public static boolean isNull(Path path) {
        boolean result = nullPath.equals(path);
        return result;
    }

    public static Path foldNulls(Path path) {
        Path result = PathTransformer.transform(path, new PathTransformerNullFold());
        return result;
    }

    public static Path canonicalizeReverseLinks(Path path) {
        Path result = PathTransformer.transform(path, new PathTransformCanonicalizeReverseLinks());
        return result;
    }

    public static Path toSparqlPath(List<P_Path0> steps) {
        return (Path)ExprUtils.opifyBalanced(steps, (a, b) -> new P_Seq(a, b));
    }

    @Deprecated
    public static P_Path0 createStep(String predicate, boolean isFwd) {
        return PathUtils.createStep(NodeFactory.createURI((String)predicate), isFwd);
    }

    @Deprecated
    public static P_Path0 createStep(Node predicate, boolean isFwd) {
        P_Link result = isFwd ? new P_Link(predicate) : new P_ReverseLink(predicate);
        return result;
    }

    @Deprecated
    public static Path create(Path path, boolean isFwd) {
        Path result = isFwd ? path : PathFactory.pathInverse((Path)path);
        return result;
    }

    public static List<P_Path0> toList(Path path) {
        Path tmp = PathUtils.canonicalizeReverseLinks(path);
        PathVisitorToList visitor = new PathVisitorToList();
        tmp.visit((PathVisitor)visitor);
        List<P_Path0> result = visitor.getResult();
        return result;
    }

    public static int countForwardLinks(Iterable<? extends Path> paths) {
        int result = (int)Streams.stream(paths).filter(p -> p instanceof P_Path0 ? ((P_Path0)p).isForward() : false).count();
        return result;
    }

    public static int countReverseLinks(Iterable<? extends Path> paths) {
        int result = (int)Streams.stream(paths).filter(p -> p instanceof P_Path0 ? !((P_Path0)p).isForward() : false).count();
        return result;
    }

    public static int compareStep(P_Path0 a, P_Path0 b) {
        int result = ComparisonChain.start().compareTrueFirst(a.isForward(), b.isForward()).compare((Object)a.getNode(), (Object)b.getNode(), NodeCmp::compareRDFTerms).result();
        return result;
    }
}

