/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.service.vfs;

import com.google.common.util.concurrent.MoreExecutors;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.IntStream;
import org.aksw.jenax.arq.service.vfs.QueryIterRepeatApplyConcurrent;
import org.aksw.jenax.arq.service.vfs.ServiceExecutorFactoryVfsUtils;
import org.aksw.jenax.arq.util.exec.query.QueryExecUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.optimize.Rewrite;
import org.apache.jena.sparql.algebra.optimize.RewriteFactory;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.service.ServiceExecutorRegistry;
import org.apache.jena.sparql.service.bulk.ChainingServiceExecutorBulk;
import org.apache.jena.sparql.service.bulk.ServiceExecutorBulk;
import org.apache.jena.sparql.service.enhancer.impl.ChainingServiceExecutorBulkServiceEnhancer;
import org.apache.jena.sparql.service.single.ChainingServiceExecutor;
import org.apache.jena.sparql.service.single.ServiceExecutor;
import org.apache.jena.sparql.util.Context;

public class ServiceExecutorFactoryRegistratorVfs {
    public static void register(Context cxt) {
        ServiceExecutorRegistry reg = ServiceExecutorRegistry.get((Context)cxt);
        if (reg == null) {
            reg = new ServiceExecutorRegistry();
            ServiceExecutorRegistry.set((Context)cxt, (ServiceExecutorRegistry)reg);
        }
        reg.addSingleLink((ChainingServiceExecutor)new ChainingServiceExecutorVfs());
        ExecutorService executorService = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newCachedThreadPool()));
        List bulkChain = reg.getBulkChain();
        int idx = IntStream.range(0, bulkChain.size()).filter(i -> ((ChainingServiceExecutorBulk)bulkChain.get(i)).getClass().equals(ChainingServiceExecutorBulkServiceEnhancer.class)).findFirst().orElse(-1);
        int maxTaskCount = Runtime.getRuntime().availableProcessors();
    }

    public static class ChainingServiceExecutorVfs
    implements ChainingServiceExecutor {
        public QueryIterator createExecution(OpService opExecute, OpService original, Binding binding, ExecutionContext execCxt, ServiceExecutor chain) {
            Node serviceNode = opExecute.getService();
            Map.Entry<Path, Map<String, String>> fileSpec = ServiceExecutorFactoryVfsUtils.toPathSpec(serviceNode);
            QueryIterator result = fileSpec == null ? chain.createExecution(opExecute, original, binding, execCxt) : ServiceExecutorFactoryVfsUtils.nextStage(opExecute, binding, execCxt, fileSpec.getKey(), fileSpec.getValue());
            return result;
        }
    }

    public static class ChainingServiceExecutorConcurrentSimple
    implements ChainingServiceExecutorBulk {
        protected static final Node CONCURRENT = NodeFactory.createURI((String)"urn:concurrent");
        protected ExecutorService executorService;
        protected int maxConcurrentTasks;

        public ChainingServiceExecutorConcurrentSimple(ExecutorService executorService, int maxConcurrentTasks) {
            this.executorService = Objects.requireNonNull(executorService);
            this.maxConcurrentTasks = maxConcurrentTasks;
        }

        public QueryIterator createExecution(OpService opService, QueryIterator input, ExecutionContext execCxt, ServiceExecutorBulk chain) {
            Object result;
            Node serviceNode = opService.getService();
            if (CONCURRENT.equals((Object)serviceNode)) {
                Context cxt = execCxt.getContext();
                RewriteFactory rf = QueryExecUtils.decideOptimizer((Context)cxt);
                Rewrite rw = rf.create(cxt);
                Op subOp = opService.getSubOp();
                final Op optimizedSubOp = rw.rewrite(subOp);
                result = new QueryIterRepeatApplyConcurrent(input, execCxt, this.executorService, this.maxConcurrentTasks){

                    @Override
                    protected QueryIterator nextStage(Binding binding, ExecutionContext localExecCxt) {
                        return QC.execute((Op)optimizedSubOp, (Binding)binding, (ExecutionContext)localExecCxt);
                    }
                };
            } else {
                result = chain.createExecution(opService, input, execCxt);
            }
            return result;
        }
    }
}

