/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.service.vfs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class PrefetchTask<T, I extends Iterator<T>>
implements Runnable {
    protected volatile I iterator;
    protected volatile List<T> bufferedItems;
    protected volatile boolean isStopRequested;
    protected volatile String state = "created";

    public PrefetchTask(I iterator) {
        this.iterator = iterator;
        this.bufferedItems = new ArrayList<T>(1024);
    }

    public List<T> getBufferedItems() {
        return this.bufferedItems;
    }

    public I getIterator() {
        return this.iterator;
    }

    @Override
    public void run() {
        this.state = "starting";
        while (!this.isStopRequested && this.iterator.hasNext()) {
            this.state = "running";
            Object item = this.iterator.next();
            this.bufferedItems.add(item);
        }
        this.state = "terminated";
    }

    public void stop() {
        this.isStopRequested = true;
    }

    public static <T, I extends Iterator<T>> PrefetchTask<T, I> of(I iterator) {
        return new PrefetchTask<T, I>(iterator);
    }
}

