/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.service.vfs;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.aksw.commons.collections.IterableUtils;
import org.aksw.commons.io.binseach.BinarySearcher;
import org.aksw.commons.io.hadoop.binseach.bz2.BlockSources;
import org.aksw.commons.io.hadoop.binseach.v2.BinSearchResourceCache;
import org.aksw.commons.io.hadoop.binseach.v2.BinarySearchBuilder;
import org.aksw.jena_sparql_api.http.domain.api.RdfEntityInfo;
import org.aksw.jena_sparql_api.io.binseach.GraphFromPrefixMatcher;
import org.aksw.jena_sparql_api.io.binseach.StageGeneratorGraphFindRaw;
import org.aksw.jenax.arq.service.vfs.ServiceExecutorBinSearch;
import org.aksw.jenax.arq.util.binding.QueryIterOverQueryExec;
import org.aksw.jenax.arq.util.exec.query.QueryExecUtils;
import org.aksw.jenax.arq.util.lang.RDFLanguagesEx;
import org.aksw.jenax.sparql.query.rx.RDFDataMgrEx;
import org.aksw.jenax.sparql.query.rx.RDFDataMgrRx;
import org.aksw.jenax.sparql.query.rx.SparqlRx;
import org.aksw.jenax.sparql.rx.op.GraphOpsRx;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.jena.atlas.data.BagFactory;
import org.apache.jena.atlas.data.DataBag;
import org.apache.jena.atlas.data.DefaultDataBag;
import org.apache.jena.atlas.data.SerializationFactory;
import org.apache.jena.atlas.data.ThresholdPolicy;
import org.apache.jena.atlas.data.ThresholdPolicyFactory;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.Rename;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIter;
import org.apache.jena.sparql.engine.iterator.QueryIterCommonParent;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.system.SerializationFactoryFinder;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceExecutorFactoryVfsUtils {
    public static final String XBINSEARCH = "x-binsearch:";
    public static final String XFSRDFSTORE = "x-fsrdfstore:";
    public static final String FILE = "file:";
    public static final String VFS = "vfs:";
    public static Supplier<SplittableCompressionCodec> CODEC_FACTORY_BZIP2 = () -> new BZip2Codec();
    protected static Logger logger = LoggerFactory.getLogger(ServiceExecutorFactoryVfsUtils.class);

    public static Path toPath(Node node) {
        Map.Entry<Path, Map<String, String>> tmp = ServiceExecutorFactoryVfsUtils.toPathSpec(node);
        Path result = tmp.getKey();
        return result;
    }

    public static Map.Entry<Path, Map<String, String>> toPathSpec(Node node) {
        Map.Entry<Path, Map<String, String>> result = node.isURI() ? ServiceExecutorFactoryVfsUtils.toPathSpec(node.getURI()) : null;
        return result;
    }

    public static Map.Entry<Path, Map<String, String>> toPathSpec(String uriStr) {
        Map.Entry<Path, Map<String, String>> result = null;
        try {
            String tmp = uriStr;
            if (tmp.startsWith(XBINSEARCH)) {
                result = ServiceExecutorFactoryVfsUtils.toPathSpecRaw(tmp = tmp.substring(XBINSEARCH.length()));
                if (result != null) {
                    result.getValue().put("binsearch", "true");
                }
            } else {
                result = ServiceExecutorFactoryVfsUtils.toPathSpecRaw(uriStr);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static Map.Entry<Path, Map<String, String>> toPathSpecRaw(String tmp) throws URISyntaxException, IOException {
        Path path = null;
        Map<Object, Object> params = new LinkedHashMap();
        boolean useVfs = false;
        boolean useFile = false;
        if (tmp.startsWith(VFS)) {
            useVfs = true;
            tmp = tmp.substring(VFS.length());
            tmp = tmp.replaceAll("^http(?!\\d+)", "http4");
        } else if (tmp.startsWith(FILE)) {
            useFile = true;
        } else {
            tmp = null;
        }
        if (tmp != null) {
            URI uri = new URI(tmp);
            params = ServiceExecutorFactoryVfsUtils.createMapFromUriQueryString(uri);
            URI effectiveUri = new URI(tmp.replaceAll("\\?.*", ""));
            if (useVfs) {
                FileSystem fs;
                String fileSystemUrl = effectiveUri.getScheme() + "://" + effectiveUri.getAuthority();
                URI fileSystemUri = URI.create(VFS + fileSystemUrl);
                try {
                    fs = FileSystems.getFileSystem(fileSystemUri);
                }
                catch (FileSystemNotFoundException e1) {
                    try {
                        Map<String, ?> env = null;
                        fs = FileSystems.newFileSystem(fileSystemUri, env);
                    }
                    catch (FileSystemAlreadyExistsException e2) {
                        fs = FileSystems.getFileSystem(fileSystemUri);
                    }
                }
                String pathStr = effectiveUri.getPath();
                Path root = (Path)IterableUtils.expectOneItem(fs.getRootDirectories());
                path = root.resolve(pathStr);
            } else if (useFile) {
                path = Paths.get(uri);
            }
        }
        Map.Entry result = path == null ? null : Maps.immutableEntry(path, params);
        return result;
    }

    public static Map<String, String> createMapFromUriQueryString(URI uri) {
        return ServiceExecutorFactoryVfsUtils.createMapFromUriQueryString(uri, new LinkedHashMap<String, String>());
    }

    public static Map<String, String> createMapFromUriQueryString(URI uri, Map<String, String> result) {
        List pairs = URLEncodedUtils.parse((URI)uri, (Charset)StandardCharsets.UTF_8);
        for (NameValuePair pair : pairs) {
            result.putIfAbsent(pair.getName(), pair.getValue());
        }
        return result;
    }

    public static Graph createGraphBinSearch(Path path, Context context) throws IOException {
        RdfEntityInfo info;
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            info = RDFDataMgrEx.probeEntityInfo((InputStream)in, Collections.singleton(Lang.NTRIPLES));
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        boolean isNtriples = Objects.equals(RDFLanguagesEx.findLang((String)info.getContentType()), Lang.NTRIPLES);
        if (!isNtriples) {
            throw new RuntimeException("No ntriples content in " + String.valueOf(path));
        }
        boolean isBzip2 = Collections.singletonList("bzip2").equals(info.getContentEncodings());
        int bufferSize = 131072;
        Context cxt = context.copy();
        BinSearchResourceCache resourceCache = ServiceExecutorBinSearch.getOrCreate(cxt);
        BinarySearchBuilder binSearchBuilder = BinarySearchBuilder.newBuilder().setSource(path).setResourceCache(resourceCache);
        boolean useV1 = false;
        BinarySearcher binarySearcher = isBzip2 ? binSearchBuilder.setCodec(CODEC_FACTORY_BZIP2.get()).build() : binSearchBuilder.build();
        GraphFromPrefixMatcher graph = new GraphFromPrefixMatcher(binarySearcher);
        return graph;
    }

    public static QueryIterator nextStage(OpService opService, Binding outerBinding, ExecutionContext execCxt, Path path, Map<String, String> params) {
        QueryIterPlainWrapper qIter;
        Context context = execCxt.getContext();
        boolean silent = opService.getSilent();
        try {
            QueryIterPlainWrapper right;
            String streamVal;
            Op opRemote = opService.getSubOp();
            Op opRestored = Rename.reverseVarRename((Op)opRemote, (boolean)true);
            Query query = OpAsQuery.asQuery((Op)opRestored);
            Map varMapping = QueryExecUtils.computeVarMapping((Op)opRemote, (Op)opRestored);
            Flowable bindingFlow = null;
            boolean specialStreamProcessingApplied = false;
            boolean useBinSearch = params.containsKey("binsearch");
            String binSearchVal = params.getOrDefault("binsearch", "");
            if (useBinSearch || "true".equalsIgnoreCase(binSearchVal)) {
                RdfEntityInfo info;
                specialStreamProcessingApplied = true;
                try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                    info = RDFDataMgrEx.probeEntityInfo((InputStream)in, Collections.singleton(Lang.NTRIPLES));
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
                boolean isNtriples = Objects.equals(RDFLanguagesEx.findLang((String)info.getContentType()), Lang.NTRIPLES);
                if (!isNtriples) {
                    throw new RuntimeException("No ntriples content in " + String.valueOf(path));
                }
                boolean isBzip2 = Collections.singletonList("bzip2").equals(info.getContentEncodings());
                int bufferSize = 131072;
                Context cxt = context.copy();
                BinSearchResourceCache resourceCache = ServiceExecutorBinSearch.getOrCreate(cxt);
                BinarySearchBuilder binSearchBuilder = BinarySearchBuilder.newBuilder().setSource(path).setResourceCache(resourceCache);
                boolean useV1 = false;
                BinarySearcher binarySearcher = useV1 ? (isBzip2 ? BlockSources.createBinarySearcherBz2((Path)path, (int)bufferSize) : BlockSources.createBinarySearcherText((Path)path, (int)bufferSize)) : (isBzip2 ? binSearchBuilder.setCodec(CODEC_FACTORY_BZIP2.get()).build() : binSearchBuilder.build());
                GraphFromPrefixMatcher graph = new GraphFromPrefixMatcher(binarySearcher);
                Object subjectCacheGraph = null;
                GraphFromPrefixMatcher finalGraph = graph;
                cxt.set(ARQ.stageGenerator, (Object)new StageGeneratorGraphFindRaw());
                QueryExec qe = QueryExec.graph((Graph)finalGraph).query(query).context(cxt).build();
                QueryIterOverQueryExec queryIterOverQueryExec = new QueryIterOverQueryExec(execCxt, qe);
            }
            if (!Strings.isNullOrEmpty((String)(streamVal = params.get("stream")))) {
                if ("s".equalsIgnoreCase(streamVal)) {
                    specialStreamProcessingApplied = true;
                    List tripleLangs = RDFLanguagesEx.getTripleLangs();
                    TypedInputStream tmp = RDFDataMgrEx.open((String)path.toString(), (Iterable)tripleLangs);
                    bindingFlow = RDFDataMgrRx.createFlowableTriples(() -> tmp).compose(GraphOpsRx.graphFromConsecutiveTriples(Triple::getSubject, GraphFactory::createDefaultGraph)).map(ModelFactory::createModelForGraph).flatMap(m -> SparqlRx.execSelectRaw(() -> QueryExecutionFactory.create((Query)query.cloneQuery(), (Model)m)));
                } else {
                    throw new RuntimeException("For streaming in SERVICE, only 's' for subjects is presently supported.");
                }
            }
            if (!specialStreamProcessingApplied) {
                Dataset dataset = DatasetFactory.create();
                try (InputStream in = RDFDataMgrEx.probeEncodings((InputStream)Files.newInputStream(path, new OpenOption[0]), null);){
                    TypedInputStream tis = RDFDataMgrEx.probeLang((InputStream)in, (Iterable)RDFDataMgrEx.DEFAULT_PROBE_LANGS);
                    Lang lang = RDFLanguages.contentTypeToLang((String)tis.getContentType());
                    RDFDataMgr.read((Dataset)dataset, (InputStream)tis.getInputStream(), (Lang)lang);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                bindingFlow = SparqlRx.execSelectRaw(() -> QueryExecutionFactory.create((Query)query, (Dataset)dataset));
            }
            if (silent && specialStreamProcessingApplied) {
                Context cxt = execCxt.getContext();
                ThresholdPolicy policy = ThresholdPolicyFactory.policyFromContext((Context)cxt);
                DefaultDataBag db = BagFactory.newDefaultBag((ThresholdPolicy)policy, (SerializationFactory)SerializationFactoryFinder.bindingSerializationFactory());
                Iterator bindingIt = bindingFlow.blockingIterable().iterator();
                db.addAll(bindingIt);
                Stream bindingStream = (Stream)Streams.stream((Iterator)db.iterator()).onClose(() -> ((DataBag)db).close());
                bindingFlow = Flowable.fromStream((Stream)bindingStream);
            }
            final Iterator tmp = bindingFlow.blockingIterable().iterator();
            qIter = right = new QueryIterPlainWrapper(tmp){

                protected void requestCancel() {
                    ((Disposable)tmp).dispose();
                    super.requestCancel();
                }

                protected void closeIterator() {
                    ((Disposable)tmp).dispose();
                    super.closeIterator();
                }
            };
            if (varMapping != null) {
                qIter = QueryIter.map((QueryIterator)qIter, (Map)varMapping);
            }
        }
        catch (Exception ex) {
            if (silent) {
                logger.warn("SERVICE <" + opService.getService().toString() + ">: " + ex.getMessage());
                return QueryIterSingleton.create((Binding)outerBinding, (ExecutionContext)execCxt);
            }
            throw new RuntimeException(ex);
        }
        QueryIterCommonParent qIter2 = new QueryIterCommonParent((QueryIterator)qIter, outerBinding, execCxt);
        return qIter2;
    }
}

