/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.service.vfs;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.aksw.jenax.arq.service.vfs.Prefetch;
import org.aksw.jenax.arq.service.vfs.TaskEntry;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIter1;
import org.apache.jena.sparql.engine.iterator.QueryIterConcat;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;

public abstract class QueryIterRepeatApplyConcurrent
extends QueryIter1 {
    private int count = 0;
    private QueryIterator currentStage = null;
    private volatile boolean cancelRequested = false;
    private final ExecutorService executorService;
    private final BlockingQueue<TaskEntry<Prefetch>> taskQueue;
    private List<TaskEntry<Prefetch>> drainedTasks;
    private static final TaskEntry<Prefetch> POISON = new TaskEntry<Object>(null, null);
    private boolean isPoisonScheduled = false;

    public QueryIterRepeatApplyConcurrent(QueryIterator input, ExecutionContext execCxt, ExecutorService executorService, int maxConcurrentTasks) {
        super(input, execCxt);
        this.executorService = executorService;
        this.taskQueue = new LinkedBlockingQueue<TaskEntry<Prefetch>>(maxConcurrentTasks);
        if (input == null) {
            Log.error((Object)((Object)this), (String)"[QueryIterConcurrentSimple] Repeated application to null input iterator");
            return;
        }
    }

    protected QueryIterator getCurrentStage() {
        return this.currentStage;
    }

    protected abstract QueryIterator nextStage(Binding var1, ExecutionContext var2);

    protected boolean hasNextBinding() {
        if (this.isFinished()) {
            return false;
        }
        while (true) {
            if (this.currentStage == null) {
                this.currentStage = this.makeNextStage();
            }
            if (this.currentStage == null) {
                return false;
            }
            if (this.cancelRequested) {
                QueryIterRepeatApplyConcurrent.performRequestCancel((QueryIterator)this.currentStage);
            }
            if (this.currentStage.hasNext()) {
                return true;
            }
            this.currentStage.close();
            this.currentStage = null;
        }
    }

    protected Binding moveToNextBinding() {
        if (!this.hasNextBinding()) {
            throw new NoSuchElementException(Lib.className((Object)((Object)this)) + ".next()/finished");
        }
        return this.currentStage.nextBinding();
    }

    private synchronized void scheduleNextTasks() {
        while (!this.isPoisonScheduled && this.taskQueue.remainingCapacity() > 0) {
            this.scheduleNextTask();
        }
    }

    private synchronized void drainAndStopAllTasks() {
        if (this.drainedTasks == null) {
            this.drainedTasks = new ArrayList<TaskEntry<Prefetch>>();
            this.taskQueue.drainTo(this.drainedTasks);
            this.drainedTasks = this.drainedTasks.stream().filter(item -> item != POISON).toList();
            this.drainedTasks.forEach(entry -> {
                Prefetch prefetch = (Prefetch)entry.task();
                prefetch.stop();
                try {
                    entry.future().get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            });
            this.schedulePoison();
        }
    }

    private void scheduleNextTask() {
        if (this.cancelRequested) {
            this.schedulePoison();
        } else {
            QueryIterator input = this.getInput();
            if (input.hasNext()) {
                ++this.count;
                Binding binding = (Binding)input.next();
                ExecutionContext execCxt = this.getExecContext();
                ExecutionContext isolatedExecCxt = new ExecutionContext(execCxt.getContext(), execCxt.getActiveGraph(), execCxt.getDataset(), execCxt.getExecutor());
                Prefetch task = new Prefetch(binding, this.nextStage(binding, isolatedExecCxt));
                Future<?> future = this.executorService.submit(task::run);
                try {
                    this.taskQueue.put(new TaskEntry<Prefetch>(task, future));
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.schedulePoison();
                input.close();
            }
        }
    }

    private void schedulePoison() {
        if (!this.isPoisonScheduled) {
            this.isPoisonScheduled = true;
            this.taskQueue.add(POISON);
        }
    }

    private QueryIterator getNextStage() {
        QueryIterConcat result;
        try {
            TaskEntry<Prefetch> entry = this.taskQueue.take();
            if (entry == POISON) {
                result = null;
            } else {
                Prefetch prefetch = entry.task();
                prefetch.stop();
                entry.future().get();
                ExecutionContext execCxt = this.getExecContext();
                result = new QueryIterConcat(execCxt);
                result.add(QueryIterPlainWrapper.create(prefetch.getBufferedItems().iterator(), (ExecutionContext)execCxt));
                result.add((QueryIterator)prefetch.getIterator());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private QueryIterator makeNextStage() {
        this.scheduleNextTasks();
        QueryIterator iter = this.getNextStage();
        return iter;
    }

    protected void closeSubIterator() {
        if (this.currentStage != null) {
            this.currentStage.close();
        }
        this.drainAndStopAllTasks();
        this.drainedTasks.forEach(entry -> ((QueryIterator)((Prefetch)entry.task()).getIterator()).close());
    }

    protected void requestSubCancel() {
        this.cancelRequested = true;
        if (this.currentStage != null) {
            this.currentStage.cancel();
        }
        this.drainAndStopAllTasks();
        this.drainedTasks.forEach(entry -> ((QueryIterator)((Prefetch)entry.task()).getIterator()).cancel());
    }
}

